/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.ExplicitImportInfo;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfCoverbin;
import ro.amiq.vlogdt.model.reflection.RfCovercross;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfCuname;
import ro.amiq.vlogdt.model.reflection.RfDuplicate;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.27.10.1")
@CheckName(value="SVTB.27.10.1")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.SHADOWING})
@CheckTitle(value="Variable names must be unique in the given scope")
@CheckDescription(value="All variables must be named with unique names in the given scope.\nExample:\nclass myclass;\n  int myint;\n  function int foo();\n    int myint; // not allowed\n  endfunction;\nendclass: myclass\n\ninterface myiface;\nendinterface:myiface\n\nmodule moo;\n  myclass myclass; // allowed iff allowVariableWithTypeName is true\n\n  function void boo(int myiface); // allowed iff allowVariableWithTypeName is true \n  endfunction\nendmodule: moo\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_10_1
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, the rule doesn't compare class parameters with the base class parameters.", name="skipInheritedParameters", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipInheritedParameters;
    @CheckParameter(defaultValue="true", description="When true, the rule allows variables to have the same name as the defined types.", name="allowVariableWithTypeName", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowVariableWithTypeName;
    @CheckParameter(defaultValue="", description="Comma separated list of method full names for which the check will be skipped.", name="skipMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipMethods;
    @CheckParameter(defaultValue="false", description="When true, the rule doesn't compare variable names with variables from the XVM API.", name="skipXVMAPI", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipXVMAPI;
    @CheckParameter(defaultValue="", description="Comma separated list of method full name patterns whose arguments will be skipped.", name="skipArgumentsOfMethodsPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private Set<Pattern> pSkipArgumentsOfMethodsPatterns;
    @CheckParameter(defaultValue="false", description="When true, the rule skips coverpoint and covercross identifiers.", name="skipCoverpointAndCovercrossIdentifiers", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipCoverpointAndCovercrossIdentifiers;
    @CheckParameter(defaultValue="true", description="When true, the rule allows action blocks to have the same label.", name="allowActionBlocksWithLabel", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowActionBlocksWithLabel;
    @CheckParameter(defaultValue="true", description="When true, the rule allows elements to have the same name as macro definitions.", name="allowElementsWithMacroNames", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowElementsWithMacroNames;
    @CheckParameter(defaultValue="false", description="When true, the rule allows local class members to have the same name as local class members from parent classes.", name="allowLocalMembers", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowLocalMembers;
    public static final Set<Class<? extends IRfNamedElement>> MEMBERS_DUPLICATE_ID = new HashSet<Class<? extends IRfNamedElement>>();
    protected Map<String, List<RfNamedElement>> visitedElements = new HashMap<String, List<RfNamedElement>>();
    protected Set<RfNamedElement> hitElements = Collections.newSetFromMap(new IdentityHashMap());
    private static final Set<Class<? extends IRfNamedElement>> TYPES = new HashSet<Class<? extends IRfNamedElement>>();
    private Map<String, List<RfNamedElement>> importedMembers;
    private DVTLinkedHashMap<String, RfNamedElement> libraryElements;
    private Set<String> allTypeNames;
    private Map<String, VlogMacroInfo> allMacroDefs;

    static {
        TYPES.add(RfModule.class);
        TYPES.add(RfPackage.class);
        TYPES.add(RfCuname.class);
        TYPES.add(RfClass.class);
        TYPES.add(RfInterface.class);
        TYPES.add(RfProgram.class);
        TYPES.add(RfFunction.class);
    }

    public Check_SVTB_27_10_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected String getFailMessage(RfNamedElement elem, RfNamedElement otherElem) {
        String message = "Duplicate identifier names visible in the same scope:\n " + this.addLineFileInfo(elem, String.valueOf(LintUtils.getElementKind(elem)) + " '" + LintUtils.getNamedElementFullName(elem) + "' - ");
        message = String.valueOf(message) + this.addLineFileInfo(otherElem, "\n " + LintUtils.getElementKind(otherElem) + " '" + LintUtils.getNamedElementFullName(otherElem) + "' - ");
        return message;
    }

    @Override
    public void performCheckImpl() {
        if (this.pAllowVariableWithTypeName) {
            this.allTypeNames = new HashSet<String>();
            for (RfNamedElement type : this.fOVMProject.getAllTypes()) {
                this.allTypeNames.add(type.getName());
            }
        }
        if (!this.pAllowElementsWithMacroNames) {
            this.allMacroDefs = new HashMap<String, VlogMacroInfo>();
            for (VlogMacroInfo macro : this.fOVMProject.getAllMacros()) {
                this.allMacroDefs.put(macro.getName(), macro);
            }
        }
        IRfNamedElementVisitor namedElementVisitor = new IRfNamedElementVisitor(){

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean visit(RfNamedElement namedElement) {
                RfFunction candidateFunction;
                void covergroup;
                void var3_2;
                RfCovergroup rfCovergroup;
                if (namedElement.isPredefined()) {
                    return true;
                }
                if (namedElement instanceof RfGenerateBlock || namedElement instanceof RfResultImplicitVariable || namedElement instanceof RfDuplicate || namedElement instanceof RfStruct || namedElement instanceof RfCoverbin) {
                    return true;
                }
                RfNamedElement rfNamedElement = namedElement;
                if (rfNamedElement instanceof RfCovergroup && (rfCovergroup = (RfCovergroup)rfNamedElement) == (RfCovergroup)var3_2 && covergroup.getEnclosingScope() instanceof RfClass) {
                    return true;
                }
                if (Check_SVTB_27_10_1.this.pAllowActionBlocksWithLabel && namedElement instanceof RfActionBlock) {
                    return true;
                }
                if (namedElement instanceof RfFunction && ((RfFunction)namedElement).isConstructor()) {
                    return true;
                }
                if (namedElement instanceof RfField && ((RfField)namedElement).isTypeParameter()) {
                    return true;
                }
                if (namedElement instanceof RfForwardTypedef) {
                    return true;
                }
                if (Check_SVTB_27_10_1.this.pAllowVariableWithTypeName && namedElement instanceof RfField && Check_SVTB_27_10_1.this.allTypeNames.contains(namedElement.getName())) {
                    return true;
                }
                if (!Check_SVTB_27_10_1.this.pSkipArgumentsOfMethodsPatterns.isEmpty() && namedElement instanceof RfField && ((RfField)namedElement).isArgument() && namedElement.getEnclosingScope() instanceof RfFunction && this.hasAllowedPattern((candidateFunction = (RfFunction)namedElement.getEnclosingScope()).getFullName())) {
                    return true;
                }
                if (Check_SVTB_27_10_1.this.pSkipCoverpointAndCovercrossIdentifiers && (namedElement instanceof RfCoverpoint || namedElement instanceof RfCovercross)) {
                    return true;
                }
                if (namedElement instanceof RfFunction && Check_SVTB_27_10_1.this.pSkipMethods.contains(namedElement.getFullName())) {
                    return true;
                }
                if (Check_SVTB_27_10_1.this.pSkipXVMAPI && Check_SVTB_27_10_1.this.fOVMProject.isOVMElement(namedElement)) {
                    return true;
                }
                RfFileDef fileDef = namedElement.getFile();
                if (fileDef != null && Check_SVTB_27_10_1.this.pathIsPrewaived(fileDef.getParserPath())) {
                    return true;
                }
                String name = namedElement.getName();
                RfNamedElement potentialLibraryElement = (RfNamedElement)Check_SVTB_27_10_1.this.libraryElements.get((Object)name);
                if (potentialLibraryElement != null && potentialLibraryElement != namedElement) {
                    if (!(potentialLibraryElement instanceof RfDuplicate)) {
                        Check_SVTB_27_10_1.this.addHit(namedElement, Check_SVTB_27_10_1.this.getFailMessage(namedElement, potentialLibraryElement));
                    } else {
                        for (RfNamedElement otherElement : potentialLibraryElement.getMembers()) {
                            if (namedElement == otherElement || namedElement instanceof RfClass && otherElement instanceof RfForwardTypedef) continue;
                            Check_SVTB_27_10_1.this.addHit(namedElement, Check_SVTB_27_10_1.this.getFailMessage(namedElement, otherElement));
                            break;
                        }
                    }
                    return true;
                }
                List<RfNamedElement> list = Check_SVTB_27_10_1.this.visitedElements.get(name);
                if (list == null) {
                    list = new ArrayList<RfNamedElement>();
                    Check_SVTB_27_10_1.this.visitedElements.put(name, list);
                }
                list.add(namedElement);
                if ((namedElement instanceof RfField || namedElement instanceof RfFunction || namedElement instanceof RfTypeAlias || namedElement instanceof RfCovergroup) && namedElement.getEnclosingScope(RfClass.class) != null || namedElement instanceof RfClass && namedElement.getEnclosingScope() instanceof RfClass) {
                    RfClass parent = namedElement instanceof RfClass ? (RfClass)namedElement.getEnclosingScope() : namedElement.getEnclosingScope(RfClass.class);
                    while (parent != null) {
                        RfNamedElement candidate;
                        DVTLinkedHashMap<String, RfNamedElement> members = parent.getLocalMembers(true);
                        if (members != null && (candidate = (RfNamedElement)members.get((Object)name)) != null) {
                            if (candidate instanceof RfDuplicate) {
                                Collection<RfNamedElement> duplicateMembers = candidate.getMembers();
                                list.addAll(duplicateMembers);
                            } else {
                                list.add(candidate);
                            }
                        }
                        if ((parent = parent.getParent()) != null && parent.getGenericClass() != null) {
                            parent = parent.getGenericClass();
                        }
                        if (!Check_SVTB_27_10_1.this.pSkipXVMAPI || parent == null || !Check_SVTB_27_10_1.this.fOVMProject.isOVMElement(parent)) continue;
                        parent = null;
                    }
                }
                return !(namedElement instanceof RfModport) && !(namedElement instanceof RfClockingBlock);
            }

            private boolean hasAllowedPattern(String name) {
                for (Pattern pattern : Check_SVTB_27_10_1.this.pSkipArgumentsOfMethodsPatterns) {
                    if (!pattern.matcher(name).matches()) continue;
                    return true;
                }
                return false;
            }
        };
        Collection<RfLibrary> libraries = this.fOVMProject.getRfProject().getAllLibraries();
        if (libraries == null) {
            return;
        }
        int memberCount = 0;
        for (RfLibrary library : libraries) {
            DVTLinkedHashMap<String, RfNamedElement> members = library.getLocalMembers(true);
            if (members == null || members.isEmpty()) continue;
            for (RfNamedElement namedElement : members) {
                if (TYPES.contains(namedElement.getClass())) {
                    this.checkMember(namedElementVisitor, members, namedElement);
                    if (++memberCount > 100) {
                        this.notifyCheckAlive();
                        memberCount = 0;
                    }
                }
                if (!(namedElement instanceof RfDuplicate)) continue;
                for (RfNamedElement duplicateMember : namedElement.getMembers()) {
                    if (!TYPES.contains(duplicateMember.getClass())) continue;
                    this.checkMember(namedElementVisitor, members, duplicateMember);
                    if (++memberCount <= 100) continue;
                    this.notifyCheckAlive();
                    memberCount = 0;
                }
            }
        }
    }

    private void checkMember(IRfNamedElementVisitor namedElementVisitor, DVTLinkedHashMap<String, RfNamedElement> libraryMembers, RfNamedElement namedElement) {
        this.visitedElements = new HashMap<String, List<RfNamedElement>>();
        this.importedMembers = new HashMap<String, List<RfNamedElement>>();
        this.libraryElements = libraryMembers;
        if (namedElement instanceof RfPackage || namedElement instanceof RfModule) {
            this.importedMembers = this.getImportedMembers(namedElement);
            for (Map.Entry<String, Object> entry : this.importedMembers.entrySet()) {
                this.visitedElements.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
            }
        }
        if (!this.pAllowElementsWithMacroNames) {
            for (Map.Entry<String, Object> entry : this.allMacroDefs.entrySet()) {
                ArrayList<RfNamedElement> array = new ArrayList<RfNamedElement>();
                array.add((RfNamedElement)entry.getValue());
                this.visitedElements.put(entry.getKey(), array);
            }
        }
        namedElement.accept(this.fOVMProject.getRfProject(), namedElementVisitor);
        for (Map.Entry<String, Object> entry : this.visitedElements.entrySet()) {
            this.hitElements = Collections.newSetFromMap(new IdentityHashMap());
            List elements = (List)entry.getValue();
            int size = elements.size();
            if (size == 1) continue;
            int i = 0;
            while (i < size) {
                RfNamedElement element = (RfNamedElement)elements.get(i);
                if (element != null) {
                    int j = i + 1;
                    while (j < size) {
                        RfNamedElement otherElement = (RfNamedElement)elements.get(j);
                        if (otherElement != null && this.compareElements(element, otherElement)) break;
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private boolean compareElements(RfNamedElement element, RfNamedElement otherElement) {
        RfLibrary otherElementLibrary;
        RfNamedElement macroLibrary;
        VlogMacroInfo macroInfo;
        VlogFileInstance fileInstance;
        if (element == otherElement) {
            return false;
        }
        if (element instanceof RfClass && otherElement instanceof RfForwardTypedef) {
            return !otherElement.equals(((RfClass)element).getTypedefDeclaration());
        }
        if (element instanceof RfForwardTypedef && otherElement instanceof RfClass) {
            return !element.equals(((RfClass)otherElement).getTypedefDeclaration());
        }
        if (this.pSkipInheritedParameters && element instanceof RfField && otherElement instanceof RfField) {
            boolean isParameter = ((RfField)element).isParameter();
            boolean isOtherParameter = ((RfField)otherElement).isParameter();
            if (isParameter && isOtherParameter) {
                return true;
            }
        }
        if (this.hitElements.contains(element)) {
            return true;
        }
        if (this.hitElements.contains(otherElement)) {
            return false;
        }
        List<RfNamedElement> list = this.importedMembers.get(element.getName());
        if (list != null && list.get(0) == otherElement) {
            this.addHit(element, this.getFailMessage(element, otherElement));
            this.hitElements.add(element);
            return true;
        }
        if (list != null && list.get(0) == element) {
            this.addHit(otherElement, this.getFailMessage(otherElement, element));
            this.hitElements.add(otherElement);
            return false;
        }
        if (element instanceof RfCoverpoint && element.isAnonymous()) {
            return false;
        }
        if (otherElement instanceof RfCoverpoint && otherElement.isAnonymous()) {
            return false;
        }
        RfNamedElement enclosingScope = element.getEnclosingScope();
        boolean isGlobalElement = false;
        if (enclosingScope instanceof RfLibrary) {
            isGlobalElement = true;
        }
        RfNamedElement otherEnclosingScope = otherElement.getEnclosingScope();
        boolean isOtherGlobalElement = false;
        if (otherEnclosingScope instanceof RfLibrary) {
            isOtherGlobalElement = true;
        }
        if (isGlobalElement && isOtherGlobalElement) {
            this.addHit(element, this.getFailMessage(element, otherElement));
            this.hitElements.add(element);
            this.addHit(otherElement, this.getFailMessage(otherElement, element));
            this.hitElements.add(otherElement);
            return false;
        }
        if (isGlobalElement) {
            if (enclosingScope == otherEnclosingScope.getEnclosingLibrary()) {
                this.addHit(otherElement, this.getFailMessage(otherElement, element));
                this.hitElements.add(otherElement);
                return false;
            }
            return false;
        }
        if (isOtherGlobalElement) {
            if (otherEnclosingScope == enclosingScope.getEnclosingLibrary()) {
                this.addHit(element, this.getFailMessage(element, otherElement));
                this.hitElements.add(element);
                return true;
            }
            return false;
        }
        if (enclosingScope == otherEnclosingScope) {
            this.addHit(element, this.getFailMessage(element, otherElement));
            this.hitElements.add(element);
            this.addHit(otherElement, this.getFailMessage(otherElement, element));
            this.hitElements.add(otherElement);
            return false;
        }
        if (enclosingScope == otherElement) {
            this.addHit(element, this.getFailMessage(element, otherElement));
            this.hitElements.add(element);
            return true;
        }
        if (element == otherEnclosingScope) {
            this.addHit(otherElement, this.getFailMessage(otherElement, element));
            this.hitElements.add(otherElement);
            return false;
        }
        RfNamedElement loopingEnclosingScope = enclosingScope;
        RfNamedElement otherLoopingEnclosingScope = otherEnclosingScope;
        while (loopingEnclosingScope != null && !(loopingEnclosingScope instanceof RfLibrary)) {
            if (loopingEnclosingScope == otherEnclosingScope || loopingEnclosingScope == otherElement) {
                this.addHit(element, this.getFailMessage(element, otherElement));
                this.hitElements.add(element);
                return true;
            }
            loopingEnclosingScope = loopingEnclosingScope.getEnclosingScope();
        }
        while (otherLoopingEnclosingScope != null && !(otherLoopingEnclosingScope instanceof RfLibrary)) {
            if (otherLoopingEnclosingScope == enclosingScope || otherLoopingEnclosingScope == element) {
                this.addHit(otherElement, this.getFailMessage(otherElement, element));
                this.hitElements.add(otherElement);
                return false;
            }
            otherLoopingEnclosingScope = otherLoopingEnclosingScope.getEnclosingScope();
        }
        if ((element instanceof RfFunction || element instanceof RfField || element instanceof RfTypeAlias || element instanceof RfCovergroup || element instanceof RfClass) && (otherElement instanceof RfFunction || otherElement instanceof RfField || otherElement instanceof RfTypeAlias || otherElement instanceof RfCovergroup || otherElement instanceof RfClass) && (!(element instanceof RfFunction) || !(otherElement instanceof RfFunction))) {
            RfClass otherEnclosingClass;
            boolean skipLocalShadowing;
            boolean bl = skipLocalShadowing = this.pAllowLocalMembers && element.isPrivate() && otherElement.isPrivate();
            if (enclosingScope instanceof RfClass && otherEnclosingScope instanceof RfClass) {
                if (!skipLocalShadowing && ((RfClass)enclosingScope).isSubClass((RfClass)otherEnclosingScope)) {
                    this.addHit(element, this.getFailMessage(element, otherElement));
                    this.hitElements.add(element);
                    return true;
                }
                if (!skipLocalShadowing && ((RfClass)otherEnclosingScope).isSubClass((RfClass)enclosingScope)) {
                    this.addHit(otherElement, this.getFailMessage(otherElement, element));
                    this.hitElements.add(otherElement);
                    return false;
                }
            }
            RfClass enclosingClass = enclosingScope instanceof RfClass ? (RfClass)enclosingScope : element.getEnclosingScope(RfClass.class);
            RfClass rfClass = otherEnclosingClass = otherEnclosingScope instanceof RfClass ? (RfClass)otherEnclosingScope : otherElement.getEnclosingScope(RfClass.class);
            if (enclosingClass != null && otherEnclosingScope instanceof RfClass && !skipLocalShadowing && enclosingClass.isSubClass((RfClass)otherEnclosingScope)) {
                this.addHit(element, this.getFailMessage(element, otherElement));
                this.hitElements.add(element);
                return true;
            }
            if (otherEnclosingClass != null && enclosingScope instanceof RfClass && !skipLocalShadowing && otherEnclosingClass.isSubClass((RfClass)enclosingScope)) {
                this.addHit(otherElement, this.getFailMessage(otherElement, element));
                this.hitElements.add(otherElement);
                return false;
            }
        }
        if (element instanceof VlogMacroInfo && (fileInstance = (macroInfo = (VlogMacroInfo)element).getFileInstance()) != null && Objects.equals(macroLibrary = fileInstance.getSemanticScope(), otherElementLibrary = otherElement.getEnclosingLibrary())) {
            int otherLine;
            int macroLine;
            int otherFileCompilationIndex;
            int macroCompilationIndex = fileInstance.getIndex();
            if (macroCompilationIndex < (otherFileCompilationIndex = otherElement.getDeclaration().getDefFile().getIndex())) {
                this.addHit(otherElement, this.getFailMessage(otherElement, element));
                this.hitElements.add(otherElement);
                return true;
            }
            if (macroCompilationIndex == otherFileCompilationIndex && (macroLine = macroInfo.getLine()) < (otherLine = otherElement.getDeclaration().getStartLine())) {
                this.addHit(otherElement, this.getFailMessage(otherElement, element));
                this.hitElements.add(otherElement);
                return true;
            }
        }
        return false;
    }

    private Map<String, List<RfNamedElement>> getImportedMembers(RfNamedElement pkg) {
        HashMap<String, List<RfNamedElement>> result = new HashMap<String, List<RfNamedElement>>();
        NullProtectedList<ImportInfo> imports = pkg.getAllImportDeclarations();
        for (ImportInfo importInfo : imports) {
            DVTLinkedHashMap<String, RfNamedElement> localMembers;
            if (importInfo instanceof ExplicitImportInfo) {
                IRfNamedElement element = ((ExplicitImportInfo)importInfo).getElement();
                if (!(element instanceof RfNamedElement)) continue;
                ArrayList<RfNamedElement> list = new ArrayList<RfNamedElement>();
                list.add((RfNamedElement)element);
                result.putIfAbsent(element.getName(), list);
                continue;
            }
            IRfPackageElement packageElement = importInfo.getPackage();
            if (!(packageElement instanceof RfPackage) || (localMembers = ((RfPackage)packageElement).getLocalMembers(true)) == null) continue;
            for (RfNamedElement localMember : localMembers) {
                ArrayList<RfNamedElement> list = new ArrayList<RfNamedElement>();
                list.add(localMember);
                result.putIfAbsent(localMember.getName(), list);
            }
        }
        return result;
    }

    protected boolean pathIsPrewaived(ParserPath path) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }
}

