/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1.6")
@CheckID(value="SVTB.27.11.1")
@CheckName(value="SVTB.27.11.1")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.DPI, RuleLabel.METHOD})
@CheckTitle(value="DPI methods naming pattern")
@CheckDescription(value="All import/export DPI methods must match the importDPINamePattern/exportDPINamePattern pattern.")
public class Check_SVTB_27_11_1
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="The import DPI method name pattern.", name="importDPINamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pImportDPINamePatternValue;
    @CheckParameter(defaultValue="", description="The export DPI method name pattern.", name="exportDPINamePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pExportDPINamePatternValue;

    public Check_SVTB_27_11_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.pImportDPINamePatternValue.pattern().isEmpty() && this.pExportDPINamePatternValue.pattern().isEmpty()) {
            this.signalParamError("Neither 'importDPINamePattern' nor 'exportDPINamePattern' parameter was specified!", false);
            return;
        }
        NullProtectedList<RfNamedElement> allMethods = new NullProtectedList<RfNamedElement>();
        allMethods.addAll(this.fOVMProject.getAllFunctions());
        allMethods.addAll(this.fOVMProject.getAllTasks());
        for (RfNamedElement method : allMethods) {
            Matcher m;
            RfFunction rfFunction;
            String methodName;
            this.notifyCheckAlive();
            if (method == null || !(method instanceof RfFunction) || (methodName = method.getName()) == null || !(rfFunction = (RfFunction)method).isDPI()) continue;
            Pattern namePattern = null;
            namePattern = rfFunction.isImportDPI() ? this.pImportDPINamePatternValue : this.pExportDPINamePatternValue;
            if (namePattern.pattern().isEmpty() || (m = namePattern.matcher(methodName)).matches()) continue;
            this.addHit(method, "Illegal name for DPI method '" + methodName + "'!");
        }
    }
}

