/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfPackage;

@CheckVersion(value="3.4")
@CheckID(value="SVTB.27.12")
@CheckName(value="SVTB.27.12")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.CLASS})
@CheckTitle(value="Class names that share common functionality should share a common prefix")
@CheckDescription(value="This creates a pseudo-namespace and reduces the chance of a naming collision.\nClasses in the same package must have a prefix matching the package name.\n\nExample:\npackage foobus_pkg;\nclass foobus_trans...\nclass foobus_xactor...\n\nImplementation Notes:\nPrefix is package name less the _pkg suffix, if any.")
public class Check_SVTB_27_12
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="true", description="Boolean, if underscore is mandatory.", name="mandatoryUnderscore", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pMandatoryUnderscore;

    public Check_SVTB_27_12(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfPackage aPackage : this.fOVMProject.getAllPackages()) {
            List<RfClass> packClasses;
            this.notifyCheckAlive();
            int endPrefix = aPackage.getName().length();
            if (aPackage.getName().endsWith("_pkg")) {
                endPrefix = aPackage.getName().length() - "_pkg".length();
            }
            String packPrefix = aPackage.getName().substring(0, endPrefix);
            if (this.pMandatoryUnderscore) {
                packPrefix = String.valueOf(packPrefix) + "_";
            }
            if ((packClasses = aPackage.getLocalMembers(RfClass.class)) == null) continue;
            for (RfClass classs : packClasses) {
                if (classs.getName().startsWith(packPrefix)) continue;
                this.addHit(classs, "Class '" + classs.getName() + "' doesn't have the package prefix '" + packPrefix + "'!");
            }
        }
    }
}

