/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_27_13;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfCheckerDef;
import ro.amiq.vlogdt.model.reflection.RfClassDef;
import ro.amiq.vlogdt.model.reflection.RfClockingBlockDef;
import ro.amiq.vlogdt.model.reflection.RfConfigurationDef;
import ro.amiq.vlogdt.model.reflection.RfCovergroupDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlockDef;
import ro.amiq.vlogdt.model.reflection.RfInterfaceDef;
import ro.amiq.vlogdt.model.reflection.RfModuleDef;
import ro.amiq.vlogdt.model.reflection.RfPackageDef;
import ro.amiq.vlogdt.model.reflection.RfPrimitiveDef;
import ro.amiq.vlogdt.model.reflection.RfProgramDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.RfPropertySequenceDef;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.CodePreprocLineInfo;

@CheckVersion(value="16.1.29")
@CheckID(value="SVTB.27.13")
@CheckName(value="SVTB.27.13")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.BEGIN_END})
@CheckTitle(value="Specify end labels for blocks")
@CheckDescription(value="All blocks must have an end label.\n\nExamples:\n\nmodule mod1;\nendmodule : mod1 // allowed\nmodule mod2;\nendmodule // not allowed\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckAutofix(value=Autofix_SVTB_27_13.class)
public class Check_SVTB_27_13
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    private static final String COLON = ":";
    private static final String END_LABEL_KEYWORD = "$keyword";
    private static final String END_LABEL = "$label";
    private static final List<String> END_BLOCKS = new ArrayList<String>(Arrays.asList("endchecker", "endclass", "endclocking", "endconfig", "endfunction", "endgroup", "endinterface", "endmodule", "endpackage", "endprimitive", "endprogram", "endproperty", "endsequence", "endtask"));
    private static final Set<String> KEYWORDS_NOT_NAMES = new HashSet<String>(Arrays.asList("final", "static", "automatic"));
    private Pattern endBlockPattern;
    @CheckParameter(defaultValue="checker, class, clocking, configuration, function, covergroup, generate, interface, module, package, primitive, program, property, sequence, task", description="Apply only for elements of type checker, class, clocking, configuration, function, covergroup, generate, interface, module, package, primitive, program, property, sequence, task. Comma separated list.", name="elementKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pElementKindsValue;
    @CheckParameter(defaultValue="", description="Define the pattern of the end label. The pattern must contain $keyword, ':' and $label.\nExamples:\n$keyword : $label\n$keyword\\s*:\\s*$label\n", name="endLabelPattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pEndLabelPattern;
    @CheckParameter(defaultValue="false", description="When true, check end labels inside inactive code.", name="checkInactiveCode", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckInactiveCode;
    @CheckParameter(defaultValue="false", description="When true, check if the end label has the correct name.", name="checkEndLabelName", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckEndLabelName;
    private Map<ParserPath, List<EndBlockLabelInfoAbstract>> labelBlockInfosForFile;
    private Pattern endLabelPattern;

    public Check_SVTB_27_13(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    /*
     * Unable to fully structure code
     */
    private boolean checkNoCommentTokensInBetween(LiteralToken token1, LiteralToken token2, ParserPath path) {
        iterToken = this.getWSParser().getNextToken(token1, path);
        if (iterToken != null) ** GOTO lbl7
        return true;
lbl-1000:
        // 1 sources

        {
            if (iterToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
                return false;
            }
            iterToken = this.getWSParser().getNextToken(iterToken, path);
lbl7:
            // 2 sources

            ** while (iterToken != null && !iterToken.equals((Object)token2))
        }
lbl8:
        // 1 sources

        return true;
    }

    private Pattern getEndBlockPattern() {
        StringBuilder regex = new StringBuilder("");
        regex.append("(");
        for (String endBlock : END_BLOCKS) {
            regex.append(String.valueOf(endBlock) + "|");
        }
        regex.deleteCharAt(regex.length() - 1);
        regex.append(")(:.*)?");
        return Pattern.compile(regex.toString());
    }

    @Override
    public void performCheckImpl() {
        this.labelBlockInfosForFile = new HashMap<ParserPath, List<EndBlockLabelInfoAbstract>>();
        LocalEndLabelDefVisitor visitor = new LocalEndLabelDefVisitor();
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        if (this.pCheckInactiveCode) {
            this.endBlockPattern = this.getEndBlockPattern();
            this.checkInsideInactiveCode();
        }
        if (!this.pEndLabelPattern.isEmpty()) {
            if (!this.pEndLabelPattern.contains(END_LABEL_KEYWORD)) {
                this.signalParamError("Invalid value: " + this.pEndLabelPattern + " for 'endLabelPattern' parameter because it does not contain '" + END_LABEL_KEYWORD + "'!", false);
                return;
            }
            if (!this.pEndLabelPattern.contains(END_LABEL)) {
                this.signalParamError("Invalid value: " + this.pEndLabelPattern + " for 'endLabelPattern' parameter because it does not contain '" + END_LABEL + "'!", false);
                return;
            }
            if (!this.pEndLabelPattern.contains(COLON)) {
                this.signalParamError("Invalid value: " + this.pEndLabelPattern + " for 'endLabelPattern' parameter because it does not contain '" + COLON + "'!", false);
                return;
            }
            try {
                String regex = this.pEndLabelPattern.replace(END_LABEL_KEYWORD, "\\w+");
                regex = regex.replace(END_LABEL, "\\w+");
                this.endLabelPattern = Pattern.compile(regex);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.signalParamError("Invalid value: " + this.pEndLabelPattern + " for 'endLabelPattern' parameter because it is not a valid regex!", false);
                return;
            }
        }
        try {
            rfProject.accept(visitor);
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (this.pEndLabelPattern.isEmpty() && !this.pCheckEndLabelName) {
            return;
        }
        try {
            for (Map.Entry<ParserPath, List<EndBlockLabelInfoAbstract>> blockInfos : this.labelBlockInfosForFile.entrySet()) {
                ParserPath path = blockInfos.getKey();
                List<EndBlockLabelInfoAbstract> blockInfosToCheck = blockInfos.getValue();
                Collections.sort(blockInfosToCheck);
                if (blockInfosToCheck == null || blockInfosToCheck.isEmpty()) continue;
                Throwable throwable = null;
                Object var8_11 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(path.path));){
                    int currentOffset = 0;
                    int currentChar = -1;
                    for (EndBlockLabelInfoAbstract blockInfo : blockInfosToCheck) {
                        String blockName;
                        int blockLine;
                        String blockType;
                        Matcher matcher;
                        int startOffset = blockInfo.startOffset;
                        int endOffset = blockInfo.endOffset;
                        while (currentOffset < startOffset) {
                            currentChar = reader.read();
                            ++currentOffset;
                        }
                        StringBuilder endLabelText = new StringBuilder();
                        while (currentOffset < endOffset) {
                            currentChar = reader.read();
                            ++currentOffset;
                            endLabelText.append((char)currentChar);
                        }
                        boolean isHit = false;
                        Matcher matcher2 = matcher = this.endLabelPattern != null ? this.endLabelPattern.matcher(endLabelText.toString()) : null;
                        if (matcher != null && !matcher.find()) {
                            isHit = true;
                        }
                        String actualEndLabel = endLabelText.toString().split(COLON)[1].trim();
                        if (this.pCheckEndLabelName && !actualEndLabel.equals(this.getBlockName(blockInfo))) {
                            isHit = true;
                        }
                        if (!isHit) continue;
                        VerissimoAutofixAdditionalInfo autofixAdditionalInfo = null;
                        if (blockInfo instanceof EndBlockLabelInfoActiveCode) {
                            blockType = this.computeElementType(((EndBlockLabelInfoActiveCode)blockInfo).defElement);
                            if (blockType == null) continue;
                            blockLine = ((EndBlockLabelInfoActiveCode)blockInfo).defElement.getEndLine();
                            blockName = LintUtils.getNamedElementFullName(((EndBlockLabelInfoActiveCode)blockInfo).defElement.getNamedElement());
                            if (!blockInfo.isUnfixable) {
                                autofixAdditionalInfo = new VerissimoAutofixAdditionalInfo(((EndBlockLabelInfoActiveCode)blockInfo).defElement, endLabelText.toString());
                            }
                        } else {
                            if (!(blockInfo instanceof EndBlockLabelInfoInactiveCode)) continue;
                            blockType = this.getCorrespondingStartBlockName(this.getEndBlockName(((EndBlockLabelInfoInactiveCode)blockInfo).parsedTokenForEndBlock));
                            blockLine = ((EndBlockLabelInfoInactiveCode)blockInfo).line;
                            blockName = ((EndBlockLabelInfoInactiveCode)blockInfo).nameOfEndBlock;
                            if (!blockInfo.isUnfixable) {
                                autofixAdditionalInfo = new VerissimoAutofixAdditionalInfo(new InactiveCodeAutofixInfo(blockName, endLabelText.toString(), startOffset));
                            }
                        }
                        if (blockInfo.isUnfixable) {
                            autofixAdditionalInfo = new VerissimoAutofixAdditionalInfo(new UnfixableAutofixInfo("end label contains comments"));
                        }
                        this.addHit(path, blockLine, "End label for " + blockType + " '" + blockName + "' does not match the specified pattern!", null, autofixAdditionalInfo);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private Object getBlockName(EndBlockLabelInfoAbstract blockInfo) {
        return blockInfo instanceof EndBlockLabelInfoActiveCode ? ((EndBlockLabelInfoActiveCode)blockInfo).defElement.getNamedElement().getName() : ((EndBlockLabelInfoInactiveCode)blockInfo).nameOfEndBlock;
    }

    private void checkInsideInactiveCode() {
        List<ParserPath> allFilesInProject = this.fOVMProject.getAllFilesInOrder();
        for (ParserPath path : allFilesInProject) {
            TreeSet<Integer> lines;
            CodePreprocFileInfo preprocInfo = this.fOVMProject.getRfProject().getPreprocessingTable().getCodePreprocFileInfos().get(path);
            if (preprocInfo == null || (lines = preprocInfo.getLines()) == null) continue;
            Iterator<Integer> iterator = lines.iterator();
            int line1 = 0;
            int line2 = 0;
            if (iterator.hasNext()) {
                line2 = iterator.next();
            }
            while (iterator.hasNext()) {
                line1 = line2;
                line2 = iterator.next();
                CodePreprocLineInfo info = preprocInfo.getInfo(line1);
                if (info.getType() == 0) continue;
                boolean isInsideInactiveMacro = false;
                int currentLine = line1;
                while (currentLine <= line2) {
                    for (LiteralToken token : this.getWSParser().getTokensOnLine(path, currentLine)) {
                        if (token.getZone() == SVTBWhitespaceParser.ZoneType.CODE && !isInsideInactiveMacro) {
                            String tokenString;
                            if (token.getStringToken().endsWith("`define")) {
                                isInsideInactiveMacro = true;
                            }
                            if ((tokenString = token.getStringToken()).startsWith("end") && this.endBlockPattern.matcher(tokenString).matches()) {
                                int endEndTokenLabel;
                                int startEndTokenOffset = token.getOffsetFile();
                                boolean isUnfixable = false;
                                String nameOfEndBlock = this.getNameOfEndBlock(token, path, preprocInfo);
                                if (nameOfEndBlock == null) continue;
                                if (tokenString.contains(COLON)) {
                                    if (tokenString.trim().endsWith(COLON)) {
                                        nextToken = this.getWSParser().getNextCodeToken(token, path);
                                        if (!this.getWSParser().getNextToken(token, path).equals(nextToken)) {
                                            isUnfixable = true;
                                        }
                                        endEndTokenLabel = nextToken.getOffsetFile() + nextToken.getLength();
                                    } else {
                                        endEndTokenLabel = token.getOffsetFile() + token.getLength();
                                    }
                                } else {
                                    nextToken = this.getWSParser().getNextCodeToken(token, path);
                                    if (!this.getWSParser().getNextToken(token, path).equals(nextToken)) {
                                        isUnfixable = true;
                                    }
                                    if (!nextToken.getStringToken().startsWith(COLON)) {
                                        String endBlockKind = DVTStringUtil.capitalizeFirstLetter((String)this.getCorrespondingStartBlockName(this.getEndBlockName(token)));
                                        this.addHit(path, currentLine, String.valueOf(endBlockKind) + " '" + nameOfEndBlock + "' block in inactive code does not have end label!", null, new VerissimoAutofixAdditionalInfo(new InactiveCodeAutofixInfo(nameOfEndBlock, "", token.getOffsetFile() + token.getLength())));
                                        continue;
                                    }
                                    if (nextToken.getStringToken().trim().equals(COLON)) {
                                        LiteralToken nextNextToken = this.getWSParser().getNextCodeToken(nextToken, path);
                                        if (!this.getWSParser().getNextToken(nextToken, path).equals(nextNextToken)) {
                                            isUnfixable = true;
                                        }
                                        endEndTokenLabel = nextNextToken.getOffsetFile() + nextNextToken.getLength();
                                    } else {
                                        endEndTokenLabel = nextToken.getOffsetFile() + nextToken.getLength();
                                    }
                                }
                                this.labelBlockInfosForFile.putIfAbsent(path, new LinkedList());
                                this.labelBlockInfosForFile.get(path).add(new EndBlockLabelInfoInactiveCode(token.getLineNumber(), startEndTokenOffset, endEndTokenLabel, token, isUnfixable, nameOfEndBlock));
                            }
                        }
                        if (!isInsideInactiveMacro || !token.isLastTokenOnLine() || token.getStringToken().endsWith("\\")) continue;
                        isInsideInactiveMacro = false;
                    }
                    ++currentLine;
                }
            }
        }
    }

    private String getEndBlockName(LiteralToken endToken) {
        String endTokenStr = endToken.getStringToken();
        int index = endTokenStr.indexOf(COLON);
        if (index != -1) {
            endTokenStr = endTokenStr.substring(0, index);
        }
        return endTokenStr;
    }

    public static String parseUntilFirstSpecialChar(String input) {
        int semicolonIndex = input.indexOf(59);
        int parenthesisIndex = input.indexOf(40);
        int hastagIndex = input.indexOf(35);
        if (semicolonIndex == -1 && parenthesisIndex == -1 && hastagIndex == -1) {
            return input;
        }
        if (semicolonIndex == -1 && parenthesisIndex == -1) {
            return input.substring(0, hastagIndex);
        }
        if (semicolonIndex == -1 && hastagIndex == -1) {
            return input.substring(0, parenthesisIndex);
        }
        if (parenthesisIndex == -1 && hastagIndex == -1) {
            return input.substring(0, semicolonIndex);
        }
        if (semicolonIndex == -1) {
            return input.substring(0, Math.min(hastagIndex, parenthesisIndex));
        }
        if (hastagIndex == -1) {
            return input.substring(0, Math.min(semicolonIndex, parenthesisIndex));
        }
        if (parenthesisIndex == -1) {
            return input.substring(0, Math.min(semicolonIndex, hastagIndex));
        }
        return input.substring(0, Math.min(Math.min(semicolonIndex, parenthesisIndex), hastagIndex));
    }

    private String getCorrespondingStartBlockName(String endBlockName) {
        if ("endgroup".equals(endBlockName)) {
            return "covergroup";
        }
        return endBlockName.substring("end".length());
    }

    private String getNameOfEndBlock(LiteralToken endToken, ParserPath path, CodePreprocFileInfo filePreprocInfo) {
        String endBlockName = this.getEndBlockName(endToken);
        String correspondingStartBlockName = this.getCorrespondingStartBlockName(endBlockName);
        int depth = 0;
        LiteralToken iterToken = this.getWSParser().getPrevToken(endToken, path);
        while (iterToken != null) {
            CodePreprocLineInfo lineInfo = filePreprocInfo.getInfo(iterToken.getLineNumber());
            if (lineInfo != null && lineInfo.getType() == 0) {
                return null;
            }
            if (iterToken.getStringToken().equals(correspondingStartBlockName) && iterToken.getZone() == SVTBWhitespaceParser.ZoneType.CODE) {
                if (depth == 0) break;
                --depth;
            } else if (this.getEndBlockName(iterToken).equals(endBlockName) && iterToken.getZone() == SVTBWhitespaceParser.ZoneType.CODE) {
                ++depth;
            }
            iterToken = this.getWSParser().getPrevToken(iterToken, path);
        }
        if (iterToken == null) {
            return null;
        }
        LiteralToken tokenName = this.getWSParser().getNextToken(iterToken, path);
        int parity = 0;
        boolean isFunction = "function".equals(iterToken.getStringToken());
        String stringToken = "";
        while (tokenName != null) {
            stringToken = tokenName.getStringToken();
            if (isFunction && (stringToken.contains("#") || parity != 0)) {
                if (!stringToken.contains("(") && parity == 0) {
                    tokenName = this.getWSParser().getNextCodeToken(tokenName, path);
                    if (tokenName == null) break;
                    StringBuilder bld = new StringBuilder();
                    bld.append(stringToken);
                    bld.append(tokenName.getStringToken());
                    stringToken = bld.toString();
                }
                int i = 0;
                while (i < stringToken.length()) {
                    if (stringToken.charAt(i) == '(') {
                        ++parity;
                    } else if (stringToken.charAt(i) == ')' && --parity == 0) {
                        stringToken = stringToken.substring(i + 1);
                        break;
                    }
                    ++i;
                }
            }
            if (parity != 0 || KEYWORDS_NOT_NAMES.contains(stringToken) || isFunction && !stringToken.contains("(") && !stringToken.contains(";")) {
                tokenName = this.getWSParser().getNextCodeToken(tokenName, path);
                continue;
            }
            if (!stringToken.startsWith("(") && !stringToken.startsWith(";")) break;
            tokenName = this.getWSParser().getPrevToken(tokenName, path);
            while (tokenName != null && tokenName.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
                tokenName = this.getWSParser().getPrevToken(tokenName, path);
            }
            if (tokenName == null) break;
            stringToken = tokenName.getStringToken();
            break;
        }
        if (tokenName == null) {
            return null;
        }
        if (tokenName.getZone() == SVTBWhitespaceParser.ZoneType.ESCAPE_IDENTIFIER) {
            return stringToken.substring(stringToken.lastIndexOf(58) + 1);
        }
        return Check_SVTB_27_13.parseUntilFirstSpecialChar(stringToken.substring(stringToken.lastIndexOf(58) + 1));
    }

    private String computeElementType(RfDefElement defElement) {
        if (defElement instanceof RfCheckerDef) {
            return "checker";
        }
        if (defElement instanceof RfClassDef) {
            return "class";
        }
        if (defElement instanceof RfClockingBlockDef) {
            return "clocking";
        }
        if (defElement instanceof RfConfigurationDef) {
            return "configuration";
        }
        if (defElement instanceof RfFunctionDef && !((RfFunction)defElement.getNamedElement()).isTask() && !((RfFunction)defElement.getNamedElement()).isLet()) {
            return "function";
        }
        if (defElement instanceof RfCovergroupDef) {
            return "covergroup";
        }
        if (defElement instanceof RfGenerateBlockDef && ((RfGenerateBlock)((RfGenerateBlockDef)defElement).getNamedElement()).hasBeginEnd()) {
            return "generate";
        }
        if (defElement instanceof RfInterfaceDef) {
            return "interface";
        }
        if (defElement instanceof RfModuleDef) {
            return "module";
        }
        if (defElement instanceof RfPackageDef) {
            return "package";
        }
        if (defElement instanceof RfPrimitiveDef) {
            return "primitive";
        }
        if (defElement instanceof RfProgramDef) {
            return "program";
        }
        if (defElement instanceof RfPropertySequenceDef && defElement.getNamedElement() instanceof RfPropertySequence) {
            RfPropertySequence propertySequence = (RfPropertySequence)defElement.getNamedElement();
            if (propertySequence.isSequence()) {
                return "sequence";
            }
            if (propertySequence.isProperty()) {
                return "property";
            }
        } else if (defElement instanceof RfFunctionDef && ((RfFunction)defElement.getNamedElement()).isTask()) {
            return "task";
        }
        return null;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private static abstract class EndBlockLabelInfoAbstract
    implements Comparable<EndBlockLabelInfoAbstract> {
        int startOffset;
        int endOffset;
        boolean isUnfixable;

        private EndBlockLabelInfoAbstract() {
        }

        @Override
        public int compareTo(EndBlockLabelInfoAbstract other) {
            return Integer.compare(this.startOffset, other.startOffset);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EndBlockLabelInfoAbstract)) {
                return false;
            }
            return this.startOffset == ((EndBlockLabelInfoAbstract)obj).startOffset;
        }

        public int hashCode() {
            return Integer.hashCode(this.startOffset);
        }
    }

    private static final class EndBlockLabelInfoActiveCode
    extends EndBlockLabelInfoAbstract {
        RfDefElement defElement;

        public EndBlockLabelInfoActiveCode(int startOffset, int endOffset, RfDefElement defElement, boolean isUnfixable) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.defElement = defElement;
            this.isUnfixable = isUnfixable;
        }
    }

    private static final class EndBlockLabelInfoInactiveCode
    extends EndBlockLabelInfoAbstract {
        int line;
        LiteralToken parsedTokenForEndBlock;
        String nameOfEndBlock;

        public EndBlockLabelInfoInactiveCode(int line, int startOffset, int endOffset, LiteralToken endBlockToken, boolean isUnfixable, String nameOfEndBlock) {
            this.line = line;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.parsedTokenForEndBlock = endBlockToken;
            this.isUnfixable = isUnfixable;
            this.nameOfEndBlock = nameOfEndBlock;
        }
    }

    public static final class InactiveCodeAutofixInfo {
        private String blockName;
        private String endBlockWithLabelName;
        private Integer endBlockOffset;

        public InactiveCodeAutofixInfo(String blockName, String endBlockWithLabelName, Integer endBlockOffset) {
            this.blockName = blockName;
            this.endBlockWithLabelName = endBlockWithLabelName;
            this.endBlockOffset = endBlockOffset;
        }

        public String getBlockName() {
            return this.blockName;
        }

        public String getEndBlockWithLabelName() {
            return this.endBlockWithLabelName;
        }

        public Integer getEndBlockOffset() {
            return this.endBlockOffset;
        }
    }

    private class LocalEndLabelDefVisitor
    implements IRfDefElementVisitor {
        private LocalEndLabelDefVisitor() {
        }

        @Override
        public boolean visit(RfDefElement defElement) throws Exception {
            return true;
        }

        @Override
        public void preVisit(RfDefElement defElement) throws Exception {
            if (defElement instanceof RfFileDef) {
                return;
            }
            if (defElement instanceof RfFieldDef && ((RfFieldDef)defElement).isImplicit()) {
                return;
            }
            if (defElement instanceof RfFunctionDef && ((RfFunctionDef)defElement).isPrototype()) {
                return;
            }
            if (defElement.getReparseInfo() != null) {
                return;
            }
            Check_SVTB_27_13.this.notifyCheckAlive();
            ParserPath parserPath = defElement.getParserPath();
            if (Check_SVTB_27_13.this.checkPreWaivers(parserPath)) {
                return;
            }
            String elementType = Check_SVTB_27_13.this.computeElementType(defElement);
            if (elementType == null) {
                return;
            }
            if (!Check_SVTB_27_13.this.pElementKindsValue.contains(elementType)) {
                return;
            }
            boolean hasEndLabel = defElement.hasEndLabel();
            if (!hasEndLabel) {
                Check_SVTB_27_13.this.addHit(parserPath, defElement.getEndLine(), String.valueOf(DVTStringUtil.capitalizeFirstLetter((String)elementType)) + " '" + LintUtils.getNamedElementFullName(defElement.getNamedElement()) + "' does not have end label!", null, new VerissimoAutofixAdditionalInfo(defElement, null));
                return;
            }
            List<EndBlockLabelInfoAbstract> blockInfos = Check_SVTB_27_13.this.labelBlockInfosForFile.get(parserPath);
            if (blockInfos == null) {
                blockInfos = new ArrayList<EndBlockLabelInfoAbstract>();
                Check_SVTB_27_13.this.labelBlockInfosForFile.put(parserPath, blockInfos);
            }
            LiteralToken endBlockToken = Check_SVTB_27_13.this.getWSParser().getTokenContainingOffset(defElement.getEndOffset(), parserPath);
            LiteralToken endLabelToken = Check_SVTB_27_13.this.getWSParser().getTokenContainingOffset(defElement.getEndLabelOffset(), parserPath);
            if (endBlockToken == null || endLabelToken == null) {
                return;
            }
            boolean isUnfixable = !endBlockToken.equals(endLabelToken) && !Check_SVTB_27_13.this.checkNoCommentTokensInBetween(endBlockToken, endLabelToken, parserPath);
            blockInfos.add(new EndBlockLabelInfoActiveCode(defElement.getEndOffset(), endLabelToken.getOffsetFile() + endLabelToken.getLength(), defElement, isUnfixable));
        }

        @Override
        public void postVisit(RfDefElement defElement) throws Exception {
        }
    }

    public static final class UnfixableAutofixInfo {
        String reason;

        public UnfixableAutofixInfo(String reason) {
            this.reason = reason;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

