/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractAllVariablesCheck;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;

@CheckVersion(value="18.1.32")
@CheckID(value="SVTB.27.14")
@CheckName(value="SVTB.27.14")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Do not use short variable names")
@CheckDescription(value="Variables names must have at least <minNofCharacters>.\n\nExamples for minNofCharacters='2':\n\nint x; // not allowed\nint yx; // allowed\nint zyx; // allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_14
extends AbstractAllVariablesCheck {
    @CheckParameter(defaultValue="2", description="The minimum allowed number of characters.", name="minNofCharacters", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    int pMinimumLength;
    @CheckParameter(defaultValue="-1", description="The minimum allowed number of characters for variables declared inside loops. Using -1 will set the value of this parameter equal to the value of <minNofCharacters>.", name="minNofCharsLoopVariables", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    int pMinNofCharsLoopVariables;

    public Check_SVTB_27_14(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        if (this.pMinNofCharsLoopVariables == -1) {
            this.pMinNofCharsLoopVariables = this.pMinimumLength;
        }
    }

    @Override
    protected void checkNamingConvention(RfNamedElement namedElement, Set<RfField> loopVariables) {
        String name = namedElement.getName();
        if (name == null) {
            return;
        }
        RfNamedElement scope = namedElement.getEnclosingScope();
        if (scope instanceof RfActionBlock && ((RfActionBlock)scope).isLoop()) {
            if (name.length() < this.pMinNofCharsLoopVariables) {
                this.addHit(namedElement, "Loop variable name '" + namedElement.getName() + "' has less than " + this.pMinNofCharsLoopVariables + " characters!");
            }
            return;
        }
        if (loopVariables.contains(namedElement)) {
            if (name.length() < this.pMinNofCharsLoopVariables) {
                this.addHit(namedElement, "Loop variable name '" + namedElement.getName() + "' has less than " + this.pMinNofCharsLoopVariables + " characters!");
            }
            return;
        }
        if (name.length() < this.pMinimumLength) {
            this.addHit(namedElement, "Variable name '" + namedElement.getName() + "' has less than " + this.pMinimumLength + " characters!");
        }
    }

    @Override
    protected Set<RfField> collectLoopVariables() {
        LoopVariablesVisitor visitor = new LoopVariablesVisitor();
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), visitor);
        return visitor.getLoopVariables();
    }

    private class LoopVariablesVisitor
    implements IHidVisitor<RfHid> {
        private RfNamedElement scope;
        private Set<RfField> loopVariables = new HashSet<RfField>();

        private LoopVariablesVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)element;
            if (this.scope instanceof RfGenerateBlock && ((RfGenerateBlock)this.scope).isLoopGenerate()) {
                if (!field.isGenvar()) {
                    return true;
                }
                this.loopVariables.add(field);
            } else {
                if (!hidObject.hasOccurrence(HidQualifierCache.LOOP_INDEX_VAR_QUALIFIER)) {
                    return true;
                }
                this.loopVariables.add(field);
            }
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }

        public Set<RfField> getLoopVariables() {
            return this.loopVariables;
        }
    }
}

