/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;

@CheckVersion(value="19.1.48")
@CheckID(value="SVTB.27.15")
@CheckName(value="SVTB.27.15")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Queue variables suffix")
@CheckDescription(value="All queue variables should have a <suffix> suffix.\n\nExamples for suffix='_q':\n\nint my_queue[$]; // not allowed\nint my_queue_q[$]; // allowed\nbit [7:0] data_q[$]; // allowed\n")
public class Check_SVTB_27_15
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="_q", description="The suffix of the queue variable.", name="suffix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pSuffix;

    public Check_SVTB_27_15(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (!(namedElement instanceof RfField)) {
                    return true;
                }
                RfField field = (RfField)namedElement;
                Check_SVTB_27_15.this.notifyCheckAlive();
                IRfNamedElement associatedType = field.getAssociatedType();
                while (associatedType instanceof RfTypeAlias) {
                    associatedType = ((RfTypeAlias)associatedType).getAssociatedType();
                }
                if (!(associatedType instanceof RfListType)) {
                    return true;
                }
                if (!((RfListType)associatedType).isQueue()) {
                    return true;
                }
                if (field.getName().endsWith(Check_SVTB_27_15.this.pSuffix)) {
                    return true;
                }
                Check_SVTB_27_15.this.addHit(namedElement, "Queue " + namedElement.getFullName() + " should have a name that ends with the suffix " + "'" + Check_SVTB_27_15.this.pSuffix + "'" + "!");
                return true;
            }
        });
    }
}

