/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="19.1.48")
@CheckID(value="SVTB.27.16")
@CheckName(value="SVTB.27.16")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.CLASS})
@CheckTitle(value="Class handles suffix")
@CheckDescription(value="All the class handles, excepting those that are instantiated using new or create, should be suffixed with <suffix>.\n\nExamples for suffix='_h':\nclass a_class;\nendclass\n\nmodule m;\n\ta_class obj; // not allowed\n\ta_class obj1 = new a_class(); // not allowed iff skipInstantiatedClassHandles=false\n\ta_class obj_h; // allowed\nendmodule\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_16
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="_h", description="The suffix of the class handle.", name="suffix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pSuffix;
    @CheckParameter(defaultValue="", description="The name pattern of the class handle. If specified the suffix is not checked.", name="namePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pNamePattern;
    @CheckParameter(defaultValue="false", description="When true, class handles declared in classes are not checked.", name="skipClassHandlesInClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipClassHandlesInClasses;
    @CheckParameter(defaultValue="true", description="When true, class handles instantiated using new or create are not checked.", name="skipInstantiatedClassHandles", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pskipInstantiatedClassHandles;
    private final Set<String> createMethods;

    public Check_SVTB_27_16(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.createMethods = new HashSet<String>(Arrays.asList(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component_registry.create"), String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object_registry.create")));
    }

    @Override
    public void performCheckImpl() {
        AssignmentOperatorVisitor assignmentVisitor = new AssignmentOperatorVisitor();
        this.fOVMProject.getRfProject().visitHidObject(null, assignmentVisitor);
        final Set<RfField> objectHandlesNewOrCreated = assignmentVisitor.getObjectHandlesNewOrCreated();
        this.fOVMProject.getRfProject().accept(new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                RfNamedElement scope;
                if (!(namedElement instanceof RfField)) {
                    return true;
                }
                if (namedElement.getFile() == null || Check_SVTB_27_16.this.checkPreWaivers(namedElement.getFile().getParserPath())) {
                    return true;
                }
                Check_SVTB_27_16.this.notifyCheckAlive();
                RfField field = (RfField)namedElement;
                if (field.isTypeParameter() || field.isParameter() || field.isArgument()) {
                    return true;
                }
                IRfNamedElement associatedType = field.getAssociatedType();
                while (associatedType instanceof RfTypeAlias) {
                    associatedType = ((RfTypeAlias)associatedType).getAssociatedType();
                }
                if (associatedType instanceof RfListType) {
                    return true;
                }
                if (Check_SVTB_27_16.this.pSkipClassHandlesInClasses && (scope = namedElement.getEnclosingScope()) instanceof RfClass) {
                    return true;
                }
                RfClass createdType = LintUtils.getFieldFinalClassTypeOrNull(field);
                if (createdType == null) {
                    return true;
                }
                if (Check_SVTB_27_16.this.pskipInstantiatedClassHandles && objectHandlesNewOrCreated.contains(field)) {
                    return true;
                }
                if (!Check_SVTB_27_16.this.pNamePattern.pattern().isEmpty()) {
                    Matcher m = Check_SVTB_27_16.this.pNamePattern.matcher(namedElement.getName());
                    if (m.matches()) {
                        return true;
                    }
                    Check_SVTB_27_16.this.addHit(namedElement, "Object handle '" + LintUtils.getNamedElementFullName(namedElement) + "' does not match the pattern '" + Check_SVTB_27_16.this.pNamePattern + "'!");
                } else {
                    if (namedElement.getFullName().endsWith(Check_SVTB_27_16.this.pSuffix)) {
                        return true;
                    }
                    Check_SVTB_27_16.this.addHit(namedElement, "Object handle '" + LintUtils.getNamedElementFullName(namedElement) + "' does not end with " + Check_SVTB_27_16.this.pSuffix + "!");
                }
                return true;
            }
        });
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class AssignmentOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;
        private Set<RfField> objectHandlesNewOrCreated = new HashSet<RfField>();
        RfNamedElement scope;

        public boolean visit(RfHidOperator operator) {
            if (Check_SVTB_27_16.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            String name = LintUtils.getFileShortName(this.parserPath.path);
            if (Check_SVTB_27_16.this.fOVMProject.isOVMFile(name)) {
                return true;
            }
            Check_SVTB_27_16.this.notifyCheckAlive();
            if (operator.hasOccurrence(HidQualifierCache.IS_DECLARATION_ASSIGN_QUALIFIER)) {
                IHidObject rhSide = operator.getFirstRHValue();
                if (!this.checkIfRhSideIsCreate(rhSide) && !this.checkIfRhSideIsNew(rhSide)) {
                    return true;
                }
                IHidObject lhValue = operator.getLHValue();
                if (!(lhValue instanceof RfHidImplicit)) {
                    return true;
                }
                IRfNamedElement fieldElement = this.scope.semanticGetLocalMember(((RfHidImplicit)lhValue).getName(), null, null, null, new HashSet<IRfNamedElement>(), null, false, false, false);
                if (!(fieldElement instanceof RfField)) {
                    return true;
                }
                this.objectHandlesNewOrCreated.add((RfField)fieldElement);
            } else if (operator.isAssignment()) {
                IHidObject rhSide = operator.getFirstRHValue();
                if (!this.checkIfRhSideIsCreate(rhSide) && !this.checkIfRhSideIsNew(rhSide)) {
                    return true;
                }
                IHidObject lhValue = operator.getLHValue();
                if (!(lhValue instanceof RfHid)) {
                    return true;
                }
                if (!(((RfHid)lhValue).getElement() instanceof RfField)) {
                    return true;
                }
                this.objectHandlesNewOrCreated.add((RfField)((RfHid)lhValue).getElement());
            }
            return true;
        }

        private boolean checkIfRhSideIsCreate(IHidObject rhSide) {
            if (!(rhSide instanceof RfHidAccessArgs)) {
                return false;
            }
            if (!(((RfHidAccessArgs)rhSide).getParentHid() instanceof RfHid)) {
                return false;
            }
            RfHid methodCallHid = (RfHid)((RfHidAccessArgs)rhSide).getParentHid();
            RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)this.scope, this.scope.getRfProject(), 34);
            resolver.resolveHidInContext((IHidObject)methodCallHid, ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.TYPE_MATCHING, (IRfNamedElement)this.scope, null, (boolean)false, (ELManager)Check_SVTB_27_16.this.fOVMProject.getRfProject().getELManager()), false);
            if (!(methodCallHid.getElement() instanceof RfFunction)) {
                return false;
            }
            RfFunction methodCallElement = (RfFunction)methodCallHid.getElement();
            return Check_SVTB_27_16.this.createMethods.contains(methodCallElement.getFullName());
        }

        private boolean checkIfRhSideIsNew(IHidObject rhSide) {
            if (rhSide instanceof RfHidOperator) {
                RfHidOperator operator = (RfHidOperator)rhSide;
                if (!"new".equals(operator.getOperatorText())) {
                    return false;
                }
                if (operator.getRHValues() != null) {
                    return false;
                }
            } else {
                if (rhSide instanceof RfHidAccessArgs) {
                    rhSide = ((RfHidAccessArgs)rhSide).getParentHid();
                }
                if (!(rhSide instanceof RfHid)) {
                    return false;
                }
                RfHid rhHid = (RfHid)rhSide;
                RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)this.scope, this.scope.getRfProject(), 34);
                resolver.resolveHidInContext((IHidObject)rhHid, ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.TYPE_MATCHING, (IRfNamedElement)this.scope, null, (boolean)false, (ELManager)Check_SVTB_27_16.this.fOVMProject.getRfProject().getELManager()), false);
                if (!(rhHid.getElement() instanceof RfFunction)) {
                    return false;
                }
                RfFunction func = (RfFunction)rhHid.getElement();
                if (!"new".equals(func.getName())) {
                    return false;
                }
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }

        public Set<RfField> getObjectHandlesNewOrCreated() {
            return this.objectHandlesNewOrCreated;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }
    }
}

