/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractBannedIdentifierCheck;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="20.1.6")
@CheckID(value="SVTB.27.17")
@CheckName(value="SVTB.27.17")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Variable naming pattern")
@CheckDescription(value="Do not use variable names that match the <namePattern>.\n\n\nExamples for namePattern='var\\d':\n\nint x; // allowed\nint var1; // not allowed\nint my_var; // allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_17
extends AbstractBannedIdentifierCheck {
    @CheckParameter(defaultValue="", description="The variable name pattern.", name="namePattern", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.REGEX)
    private Pattern pNamePatternValue;

    public Check_SVTB_27_17(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<Pattern> patterns = new HashSet<Pattern>();
        patterns.add(this.pNamePatternValue);
        this.checkNamedElements(patterns, true);
    }

    @Override
    protected boolean shouldFilterNamedElement(RfNamedElement namedElement) {
        return !(namedElement instanceof RfField);
    }
}

