/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="20.1.8")
@CheckID(value="SVTB.27.18")
@CheckName(value="SVTB.27.18")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.ASSERTION})
@CheckTitle(value="Assertion naming pattern")
@CheckDescription(value="All assertions of kind <assertionKind> must match the <namePattern>.\n\nExamples for default assetionKind and namePattern='ALL_[A-Z_]*':\n\nALL_AP_ASSERT_PROP : assert property(A == B); // allowed\nCONCURENT_AP_ASSERT_PROP : assert property(A == B); // not allowed\nALL_IMMEDIATE_EXPECT: expect (A == B) $display (\"OK.\"); // allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_18
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="The assertion name pattern.", name="namePattern", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.REGEX)
    private Pattern pNamePatternValue;
    @CheckParameter(defaultValue="concurrent_assert, concurrent_assume, concurrent_cover_sequence, concurrent_cover_property, expect, immediate_assert, immediate_assume, immediate_cover, restrict", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover_sequence, concurrent_cover_property, expect, immediate_assert, immediate_assume, immediate_cover, restrict.", name="assertionKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAssertionKindValue;
    private Set<String> allKinds = new HashSet<String>(Arrays.asList("concurrent_assert", "concurrent_assume", "concurrent_cover_sequence", "concurrent_cover_property", "expect", "immediate_assert", "immediate_assume", "immediate_cover", "restrict"));

    public Check_SVTB_27_18(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        for (String kind : this.pAssertionKindValue) {
            if (this.allKinds.contains(kind)) continue;
            this.signalParamError("Invalid assertion kind: " + kind + "!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        if (this.pNamePatternValue.pattern().isEmpty() || this.pAssertionKindValue.isEmpty()) {
            return;
        }
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(this.pAssertionKindValue);
        for (RfNamedElement assertion : this.fOVMProject.getAllAssertsExpects()) {
            Matcher variableNameMatcher;
            if (!(assertion instanceof RfAssertExpect)) continue;
            RfAssertExpect tmpAssertion = (RfAssertExpect)assertion;
            RfFileDef file = assertion.getFile();
            if (file == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) continue;
            this.notifyCheckAlive();
            int assertType = tmpAssertion.getAssertType();
            if (!numericalAssertKind.isEmpty() && !numericalAssertKind.contains(assertType)) continue;
            boolean isAnonymous = tmpAssertion.isAnonymous();
            if (isAnonymous) {
                this.addHit(assertion, "The " + LintUtils.getElementKind(assertion) + " does not have a name!");
                continue;
            }
            String elementName = tmpAssertion.getName();
            if (elementName == null || (variableNameMatcher = this.pNamePatternValue.matcher(elementName)).matches()) continue;
            this.addHit(assertion, "The name of " + LintUtils.getElementKind(assertion) + " '" + LintUtils.getNamedElementFullName(assertion) + "' does not match the specified pattern '" + this.pNamePatternValue.pattern() + "'!");
        }
    }

    private Set<Integer> getNumericalAssertKind(HashSet<String> literalAssertionKind) {
        HashSet<Integer> numericalAssertKinds = new HashSet<Integer>();
        for (String elementKind : literalAssertionKind) {
            if (elementKind.equals("immediate_assert")) {
                numericalAssertKinds.add(0);
            }
            if (elementKind.equals("concurrent_assert")) {
                numericalAssertKinds.add(2);
            }
            if (elementKind.equals("expect")) {
                numericalAssertKinds.add(1);
            }
            if (elementKind.equals("immediate_assume")) {
                numericalAssertKinds.add(3);
            }
            if (elementKind.equals("concurrent_assume")) {
                numericalAssertKinds.add(4);
            }
            if (elementKind.equals("immediate_cover")) {
                numericalAssertKinds.add(5);
            }
            if (elementKind.equals("concurrent_cover_sequence")) {
                numericalAssertKinds.add(7);
            }
            if (elementKind.equals("concurrent_cover_property")) {
                numericalAssertKinds.add(6);
            }
            if (!elementKind.equals("restrict")) continue;
            numericalAssertKinds.add(8);
        }
        return numericalAssertKinds;
    }
}

