/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="20.1.9")
@CheckID(value="SVTB.27.19")
@CheckName(value="SVTB.27.19")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Type naming pattern")
@CheckDescription(value="Do not use type names that match the <namePattern>.\n\nExamples for default assetionKind and namePattern='.*_e':\n\nclass my_class_e; // not allowed\nendclass\nclass simple_class; // allowed\nendclass\nmodule my_module_e; // not allowed\nendmodule\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_19
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="The type name pattern.", name="namePattern", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.REGEX)
    private Pattern pNamePatternValue;

    public Check_SVTB_27_19(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfNamedElement[] allTypes;
        if (this.pNamePatternValue.pattern().isEmpty()) {
            return;
        }
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        RfNamedElement[] rfNamedElementArray = allTypes = rfProject.getAllTypes(true, true);
        int n = allTypes.length;
        int n2 = 0;
        while (n2 < n) {
            RfNamedElement namedElement = rfNamedElementArray[n2];
            if (!this.isPrewaived(namedElement)) {
                Matcher typeNameMatcher;
                this.notifyCheckAlive();
                String typeName = namedElement.getName();
                if (typeName != null && (typeNameMatcher = this.pNamePatternValue.matcher(typeName)) != null && typeNameMatcher.matches()) {
                    this.addHit(namedElement, String.valueOf(DVTStringUtil.capitalizeFirstLetter((String)LintUtils.getElementKind(namedElement))) + " name " + " '" + LintUtils.getNamedElementFullName(namedElement) + "' matches the forbidden pattern '" + this.pNamePatternValue.pattern() + "'!", null);
                }
            }
            ++n2;
        }
    }

    private boolean isPrewaived(RfNamedElement namedElement) {
        RfFileDef file = namedElement.getFile();
        if (file == null) {
            return true;
        }
        ParserPath parserPath = file.getParserPath();
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

