/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.CITElementsVisitor;
import ro.amiq.vlogdt.linter.svtb.ICITElementsVisitorImpl;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.27.1.0")
@CheckName(value="SVTB.27.1.0")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Element suffix")
@CheckDescription(value="All <elementKind>s should match the <namePattern> or have a <suffix> suffix.\n\nExamples for elementKind='class' and suffix='_class':\nclass a; // not allowed\nendclass\nclass my_class; // allowed\nendclass\nclass test_class; // allowed\nendclass\n\nExamples for elementKind='typedef', suffix='_t', skipIfTypedefTo='union,struct,enum' and skipNestedTypedefsOfStructs='true':\ntypedef enum {a, b} c; // allowed\ntypedef c d; // not allowed\ntypedef c e_t; // allowed")
public class Check_SVTB_27_1_0
extends OVMComplianceCheck
implements ICITElementsVisitorImpl {
    @CheckParameter(defaultValue="class", description="One of the following: package, class, interface class, non-interface class, module, interface, struct, union, enum, function, task, typedef, clocking, modport, covergroup, parameter, enum item, assert, property, constraint, sequence, assume, cover. class includes both interface class and non-interface class, typedef enum is enum, similar for struct, union.", name="elementKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pElementKindValue;
    @CheckParameter(defaultValue="false", description="If type aliases (typedefs) to elementKind should follow the elementKind naming conventions. Applicable only for targets class, interface, modport.", name="checkTypedefs", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckTypedefsValue;
    @CheckParameter(defaultValue="", description="Relevant when checking typedefs. Comma separated list of enum, struct, union, class, interface, modport.", name="skipIfTypedefTo", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipIfTypedefToValue;
    @CheckParameter(defaultValue="", description="The suffix. When empty, these are the predefined values for suffix: _pkg - package, _c - class, _if - interface, _s - struct, _u - union, _e - enum, _t - typedef, _cb - clocking, _mp - modport, _cg - covergroup, _cs - constraint, _a - assert, _p - property, _sq - sequence, _m - assume, _c - cover.", name="suffix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pSuffix;
    @CheckParameter(defaultValue="", description="The element name pattern. If specified the suffix is not checked.", name="namePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pNamePatternValue;
    @CheckParameter(defaultValue="", description="Comma separated list of legal name exceptions. For example ''type_id'' aliases to self inside a class or short names like ''cg'' for a covergroup.", name="elementNameExceptions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pNameExceptionsValue;
    @CheckParameter(defaultValue="", description="Comma separated list of macro prefixes, for example uvm_.", name="skipElementsDeclaredInsideMacrosWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipElementsDeclaredInsideMacrosWithPrefixesValue;
    @CheckParameter(defaultValue="false", description="If true, only <elementKind>s should match the <namePattern> or have a <suffix> suffix.", name="exclusive", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pEnforceExclusivity;
    @CheckParameter(defaultValue="false", description="When <skipIfTypedefTo> contains struct, enum or union and parameter is set to true nested typedefs over struct, enum and union are considered typedef, not struct, union or enum.", name="skipNestedTypedefsOfStructs", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipNestedTypedefsOfStructs;
    @CheckParameter(defaultValue="", description="Type of fields that should not be checked. Comma separated list of enum, struct, union, class, interface, typedef.", name="skipFieldsOfType", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipFieldsOfType;
    private String fSuffixValue;
    private Set<String> allowedKindValues = new HashSet<String>(Arrays.asList("package", "class", "interface class", "non-interface class", "module", "interface", "struct", "union", "enum", "function", "task", "typedef", "clocking", "modport", "covergroup", "parameter", "enum item", "assert", "property", "constraint", "sequence", "assume", "cover"));

    public Check_SVTB_27_1_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    protected String getParamSuffix(String aElementKind) {
        String result = this.pSuffix;
        if (result == null || result.isEmpty()) {
            if ("class".equals(aElementKind)) {
                return "_c";
            }
            if ("interface".equals(aElementKind)) {
                return "_if";
            }
            if ("package".equals(aElementKind)) {
                return "_pkg";
            }
            if ("struct".equals(aElementKind)) {
                return "_s";
            }
            if ("union".equals(aElementKind)) {
                return "_u";
            }
            if ("enum".equals(aElementKind)) {
                return "_e";
            }
            if ("constraint".equals(aElementKind)) {
                return "_cs";
            }
            if ("clocking".equals(aElementKind)) {
                return "_cb";
            }
            if ("modport".equals(aElementKind)) {
                return "_mp";
            }
            if ("covergroup".equals(aElementKind)) {
                return "_cg";
            }
            if ("typedef".equals(aElementKind)) {
                return "_t";
            }
            if ("assert".equals(aElementKind)) {
                return "_a";
            }
            if ("property".equals(aElementKind)) {
                return "_p";
            }
            if ("sequence".equals(aElementKind)) {
                return "_sq";
            }
            if ("assume".equals(aElementKind)) {
                return "_m";
            }
            if ("cover".equals(aElementKind)) {
                return "_c";
            }
            return null;
        }
        return result;
    }

    @Override
    public void configure() {
        super.configure();
        if (!this.allowedKindValues.contains(this.pElementKindValue)) {
            this.signalParamError("Invalid value: " + this.pElementKindValue + " for 'elementKind'!", true);
        }
        this.fSuffixValue = this.getParamSuffix(this.pElementKindValue);
        if (this.fSuffixValue == null && this.pNamePatternValue.pattern().isEmpty()) {
            this.signalParamError("No value for 'suffix' or 'namePattern' parameters!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        new CITElementsVisitor(this.fOVMProject, this, this.pElementKindValue, this.pCheckTypedefsValue, this.pEnforceExclusivity, this.pSkipIfTypedefToValue, this.pSkipElementsDeclaredInsideMacrosWithPrefixesValue, this.pSkipNestedTypedefsOfStructs, this.pSkipFieldsOfType).visit();
    }

    @Override
    public void visitCITElement(RfNamedElement aRfNamedElement, String aHitPrefix, boolean isOfElementKind) {
        this.notifyCheckAlive();
        String elementName = aRfNamedElement.getName();
        if (this.pNameExceptionsValue != null && this.pNameExceptionsValue.contains(elementName)) {
            return;
        }
        if (!this.pNamePatternValue.pattern().isEmpty()) {
            Matcher m = this.pNamePatternValue.matcher(elementName);
            if (!isOfElementKind) {
                if (m.matches()) {
                    this.addHit(aRfNamedElement, String.valueOf(aHitPrefix) + "matches the " + this.pElementKindValue + "-exclusive pattern '" + this.pNamePatternValue.pattern() + "'!");
                }
            } else if (!m.matches()) {
                this.addHit(aRfNamedElement, String.valueOf(aHitPrefix) + "does not match the pattern '" + this.pNamePatternValue.pattern() + "'!");
            }
        } else if (!isOfElementKind) {
            if (elementName.endsWith(this.fSuffixValue)) {
                this.addHit(aRfNamedElement, String.valueOf(aHitPrefix) + "ends with the " + this.pElementKindValue + "-exclusive suffix '" + this.fSuffixValue + "'!");
            }
        } else if (!elementName.endsWith(this.fSuffixValue)) {
            this.addHit(aRfNamedElement, String.valueOf(aHitPrefix) + "does not end with '" + this.fSuffixValue + "'!");
        }
    }
}

