/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractBeginEndLabelCheck;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfDefElement;

@CheckVersion(value="20.1.27")
@CheckID(value="SVTB.27.20")
@CheckName(value="SVTB.27.20")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.BEGIN_END})
@CheckTitle(value="Begin label pattern")
@CheckDescription(value="All begin labels must follow the pattern specified in the <beginLabelPattern> parameter.\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_20
extends AbstractBeginEndLabelCheck
implements IWhitespaceParserCheck {
    private static final String COLON = ":";
    private static final String BEGIN_LABEL_KEYWORD = "$keyword";
    private static final String BEGIN_LABEL = "$label";
    @CheckParameter(defaultValue="", description="Define the pattern of the begin label. The pattern must contain $keyword, ':'.\n$label or a specific naming pattern may be used for the label name.\nExamples:\n$keyword : $label\n$keyword\\s*:\\s*$label\n$keyword\\s*:\\s*[A-Z0-9_]+", name="beginLabelPattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pBeginLabelPattern;
    private Pattern beginLabelPattern;

    public Check_SVTB_27_20(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected boolean pathIsPrewaived(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    @Override
    protected boolean preAnalyzeParameters() {
        if (this.pBeginLabelPattern.isEmpty()) {
            return false;
        }
        boolean standardLabel = false;
        if (!this.pBeginLabelPattern.contains(BEGIN_LABEL_KEYWORD)) {
            this.signalParamError("Invalid value: " + this.pBeginLabelPattern + " for 'beginLabelPattern' parameter because it does not contain '" + BEGIN_LABEL_KEYWORD + "'!", false);
            return false;
        }
        if (this.pBeginLabelPattern.contains(BEGIN_LABEL)) {
            standardLabel = true;
        }
        if (!this.pBeginLabelPattern.contains(COLON)) {
            this.signalParamError("Invalid value: " + this.pBeginLabelPattern + " for 'beginLabelPattern' parameter because it does not contain '" + COLON + "'!", false);
            return false;
        }
        try {
            String regex = this.pBeginLabelPattern.replace(BEGIN_LABEL_KEYWORD, "begin");
            if (standardLabel) {
                regex = regex.replace(BEGIN_LABEL, "\\w+");
            }
            this.beginLabelPattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.signalParamError("Invalid value: " + this.pBeginLabelPattern + " for 'beginLabelPattern' parameter because it is not a valid regex!", false);
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void analyzeDefinitions(List<RfDefElement> definitionsToCheck, BufferedReader reader, ParserPath path) throws IOException {
        currentOffset = 0;
        currentChar = -1;
        for (RfDefElement definition : definitionsToCheck) {
            this.notifyCheckAlive();
            tokenCount = 0;
            beginLabelOffset = definition.getLabelStartOffset();
            labelToken = this.getWSParser().getTokenContainingOffset(beginLabelOffset + 1, path);
            if (labelToken != null) ** GOTO lbl-1000
            continue;
            while ((labelToken = this.getWSParser().getPrevToken(labelToken, path)) != null && (labelToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE || ++tokenCount <= 3)) lbl-1000:
            // 2 sources

            {
                if (labelToken.getStringToken() != null && (!labelToken.getStringToken().startsWith("begin") || labelToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE)) continue;
            }
            if (tokenCount > 3 || labelToken == null || !labelToken.getStringToken().startsWith("begin")) continue;
            startOffset = labelToken.getOffsetFile();
            beginLabelText = new StringBuilder();
            while (currentOffset < startOffset) {
                currentChar = reader.read();
                ++currentOffset;
            }
            while (currentOffset < beginLabelOffset + definition.getName().length()) {
                currentChar = reader.read();
                ++currentOffset;
                beginLabelText.append((char)currentChar);
            }
            if (beginLabelText.toString().isEmpty() || (matcher = this.beginLabelPattern.matcher(beginLabelText.toString())).find()) continue;
            this.addHit(path, labelToken.getLineNumber(), "Begin label '" + beginLabelText.toString() + "' does not match the specified pattern!", null);
        }
    }
}

