/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractBeginEndLabelCheck;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfDefElement;

@CheckVersion(value="20.1.36")
@CheckID(value="SVTB.27.20.1")
@CheckName(value="SVTB.27.20.1")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.BEGIN_END})
@CheckTitle(value="End label pattern")
@CheckDescription(value="All end labels must follow the pattern specified in the <endLabelPattern> parameter.\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_20_1
extends AbstractBeginEndLabelCheck
implements IWhitespaceParserCheck {
    private static final String COLON = ":";
    private static final String END_LABEL_KEYWORD = "$keyword";
    private static final String END_LABEL = "$label";
    @CheckParameter(defaultValue="", description="Define the pattern of the end label. The pattern must contain $keyword, ':'.\n$label or a specific naming pattern may be used for the label name.\nExamples:\n$keyword : $label\n$keyword\\s*:\\s*$label\n$keyword\\s*:\\s*[A-Z0-9_]+", name="endLabelPattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pEndLabelPattern;
    private Pattern endLabelPattern;

    public Check_SVTB_27_20_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected boolean pathIsPrewaived(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    @Override
    protected boolean preAnalyzeParameters() {
        if (this.pEndLabelPattern.isEmpty()) {
            return false;
        }
        boolean standardLabel = false;
        if (!this.pEndLabelPattern.contains(END_LABEL_KEYWORD)) {
            this.signalParamError("Invalid value: " + this.pEndLabelPattern + " for 'endLabelPattern' parameter because it does not contain '" + END_LABEL_KEYWORD + "'!", false);
            return false;
        }
        if (this.pEndLabelPattern.contains(END_LABEL)) {
            standardLabel = true;
        }
        if (!this.pEndLabelPattern.contains(COLON)) {
            this.signalParamError("Invalid value: " + this.pEndLabelPattern + " for 'endLabelPattern' parameter because it does not contain '" + COLON + "'!", false);
            return false;
        }
        try {
            String regex = this.pEndLabelPattern.replace(END_LABEL_KEYWORD, "end");
            if (standardLabel) {
                regex = regex.replace(END_LABEL, "\\w+");
            }
            this.endLabelPattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.signalParamError("Invalid value: " + this.pEndLabelPattern + " for 'endLabelPattern' parameter because it is not a valid regex!", false);
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void analyzeDefinitions(List<RfDefElement> definitionsToCheck, BufferedReader reader, ParserPath path) throws IOException {
        currentOffset = 0;
        currentChar = -1;
        for (RfDefElement definition : definitionsToCheck) {
            this.notifyCheckAlive();
            tokenCount = 0;
            endLabelOffset = definition.getEndLabelOffset();
            labelToken = this.getWSParser().getTokenContainingOffset(endLabelOffset + 1, path);
            if (labelToken != null) ** GOTO lbl-1000
            continue;
            while ((labelToken = this.getWSParser().getPrevToken(labelToken, path)) != null && (labelToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE || ++tokenCount <= 3)) lbl-1000:
            // 2 sources

            {
                if (labelToken.getStringToken() != null && (!labelToken.getStringToken().startsWith("end") || labelToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE)) continue;
            }
            if (tokenCount > 3 || labelToken == null || !labelToken.getStringToken().startsWith("end")) continue;
            endOffset = labelToken.getOffsetFile();
            endLabelText = new StringBuilder();
            while (currentOffset < endOffset) {
                currentChar = reader.read();
                ++currentOffset;
            }
            while (currentOffset < endLabelOffset + definition.getName().length()) {
                currentChar = reader.read();
                ++currentOffset;
                endLabelText.append((char)currentChar);
            }
            if (endLabelText.toString().isEmpty() || (matcher = this.endLabelPattern.matcher(endLabelText.toString())).find()) continue;
            this.addHit(path, labelToken.getLineNumber(), "End label '" + endLabelText.toString() + "' does not match the specified pattern!", null);
        }
    }
}

