/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfAbstractBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlockDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="20.1.30")
@CheckID(value="SVTB.27.21")
@CheckName(value="SVTB.27.21")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.BEGIN_END})
@CheckTitle(value="Begin label")
@CheckDescription(value="All begin labels must have a name.\n\nExamples:\n\nif (a != b) begin : my_block // allowed\nend\nif (a == b) begin // not allowed\nend\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_21
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="generate_block, action_block", description="Comma separated list of block types on which the check will be applied: action_block, generate_block.", name="blockTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    public HashSet<String> pBlockTypes;
    @CheckParameter(defaultValue="", description="Comma separated list of: if, for, case. If empty, all begin end block types are checked.", name="statementTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    public Set<String> pStatementTypes;

    public Check_SVTB_27_21(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        LocalBeginLabelDefVisitor visitor = new LocalBeginLabelDefVisitor();
        try {
            rfProject.accept(visitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.fOVMProject.notifyCheckException(this, e);
        }
    }

    private boolean applyOnGenerateBlocks() {
        return this.pBlockTypes.contains("generate_block");
    }

    private boolean applyOnActionBlocks() {
        return this.pBlockTypes.contains("action_block");
    }

    private class LocalBeginLabelDefVisitor
    implements IRfDefElementVisitor {
        private LocalBeginLabelDefVisitor() {
        }

        @Override
        public boolean visit(RfDefElement defElement) throws Exception {
            return true;
        }

        @Override
        public void preVisit(RfDefElement defElement) throws Exception {
            if (defElement instanceof RfFileDef) {
                return;
            }
            if (defElement instanceof RfFieldDef && ((RfFieldDef)defElement).isImplicit()) {
                return;
            }
            if (defElement instanceof RfFunctionDef && ((RfFunctionDef)defElement).isPrototype()) {
                return;
            }
            if (defElement.getReparseInfo() != null) {
                return;
            }
            Check_SVTB_27_21.this.notifyCheckAlive();
            ParserPath parserPath = defElement.getParserPath();
            if (Check_SVTB_27_21.this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, Check_SVTB_27_21.this)) {
                return;
            }
            if (this.isHit(defElement)) {
                Check_SVTB_27_21.this.addHit(parserPath, defElement.getStartLine(), "Begin label name is missing for this block!", null);
            }
        }

        @Override
        public void postVisit(RfDefElement defElement) throws Exception {
        }

        private boolean isHit(RfDefElement defElement) {
            if (!this.checkBlockType(defElement)) {
                return false;
            }
            if (defElement instanceof RfGenerateBlockDef && defElement.getNamedElement() instanceof RfGenerateBlock) {
                return ((RfGenerateBlock)defElement.getNamedElement()).hasImplicitName() && ((RfGenerateBlock)defElement.getNamedElement()).hasBeginEnd() && Check_SVTB_27_21.this.applyOnGenerateBlocks();
            }
            if (defElement instanceof RfActionBlockDef && defElement.getNamedElement() instanceof RfActionBlock) {
                return ((RfActionBlock)defElement.getNamedElement()).hasBeginEnd() && ((RfActionBlock)defElement.getNamedElement()).isAnonymous() && Check_SVTB_27_21.this.applyOnActionBlocks();
            }
            return false;
        }

        private boolean checkBlockType(RfDefElement defElement) {
            RfNamedElement blockScope;
            if (Check_SVTB_27_21.this.pStatementTypes.isEmpty()) {
                return true;
            }
            RfNamedElement element = defElement.getNamedElement();
            if (!(element instanceof RfAbstractBlock)) {
                return false;
            }
            RfAbstractBlock abstractBlock = (RfAbstractBlock)element;
            if (Check_SVTB_27_21.this.pStatementTypes.contains("if") && abstractBlock.isIf()) {
                return true;
            }
            if (Check_SVTB_27_21.this.pStatementTypes.contains("for") && (abstractBlock instanceof RfGenerateBlock ? abstractBlock.isFor() : (blockScope = abstractBlock.getEnclosingScope()) instanceof RfActionBlock && ((RfActionBlock)blockScope).isForOrForeach())) {
                return true;
            }
            return Check_SVTB_27_21.this.pStatementTypes.contains("case") && abstractBlock.isCaseItem();
        }
    }
}

