/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractBannedIdentifierCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

@CheckVersion(value="21.1.10")
@CheckID(value="SVTB.27.22")
@CheckName(value="SVTB.27.22")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Do not use banned words")
@CheckDescription(value="This rule checks that the following: type names, variable names, comments, file names and string literals do not match the <bannedPatterns>.\n\nExamples for bannedPatterns='hit_.*':\n\n/* Variables for hit_message */ // not allowed\nstring hit_string; // not allowed\nstring message_hit; // allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_22
extends AbstractBannedIdentifierCheck {
    private static final Pattern WORD_DELIMITER = Pattern.compile("\\W+");
    private static final Pattern LINE_DELIMITER = Pattern.compile("\\R");
    @CheckParameter(defaultValue="", description="Comma separated list of banned patterns. Either bannedPatternsList or bannedWordsFile must have a value set!", name="bannedPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pIdentifierPatterns;
    @CheckParameter(defaultValue="", description="Path to a file that contains banned words. The format expected in the file is one word per line.\nEither bannedPatternsList or bannedWordsFile must have a value set!", name="bannedWordsFile", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pBannedWordsFile;
    @CheckParameter(defaultValue="false", description="When true, check words matching <bannedPatterns> inside inactive code.", name="checkInactiveCode", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckInactiveCode;
    @CheckParameter(defaultValue="false", description="When true, skips checking any comments for banned words.", name="skipComments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipComments;
    @CheckParameter(defaultValue="false", description="When true, skips checking any string literals.", name="skipStringLiterals", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipStringLiterals;
    private HashSet<String> bannedWords;

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(136);
    }

    public Check_SVTB_27_22(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void configureBeforeRuleImplementation() {
        this.bannedWords = new HashSet();
        if (this.pIdentifierPatterns.isEmpty() && this.pBannedWordsFile.isEmpty()) {
            this.signalParamError("Neither 'bannedPatterns' nor 'bannedPatternsFile' has a value set.", true);
            return;
        }
        if (!this.pBannedWordsFile.isEmpty()) {
            String wordsFilePath = LintUtils.replaceAllSystemVariables(this.fOVMProject.getProject(), this.pBannedWordsFile, DVTUtilsCommon.ReplaceSysvarsPolicy.RETURN_NULL);
            if (wordsFilePath == null) {
                this.signalParamError("Rule parameter '" + this.pBannedWordsFile + "' contains invalid system variable!", true);
                return;
            }
            this.addBannedWordsFromFile(wordsFilePath);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addBannedWordsFromFile(String filePath) {
        File prefsFile = new File(filePath);
        if (!prefsFile.canRead()) {
            this.signalParamError("Can't read " + prefsFile.getPath(), true);
            return;
        }
        BufferedReader input = null;
        try {
            try {
                String line;
                input = new BufferedReader(new FileReader(prefsFile));
                while ((line = input.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    this.bannedWords.add(line);
                }
                return;
            }
            catch (FileNotFoundException e) {
                this.signalParamError("Can't find " + prefsFile.getPath(), true);
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
                if (input == null) return;
                try {
                    input.close();
                    return;
                }
                catch (IOException e2) {
                    this.fOVMProject.notifyCheckException(this, e2);
                    DVTLogger.INSTANCE.logError((Throwable)e2);
                }
                return;
            }
            catch (IOException e) {
                this.signalParamError("I/O exception occured while reading " + prefsFile.getPath(), true);
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
                if (input == null) return;
                try {
                    input.close();
                    return;
                }
                catch (IOException e3) {
                    this.fOVMProject.notifyCheckException(this, e3);
                    DVTLogger.INSTANCE.logError((Throwable)e3);
                }
                return;
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    this.fOVMProject.notifyCheckException(this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
    }

    @Override
    public void performCheckImpl() {
        if (this.hasConfigurationErrors()) {
            return;
        }
        this.checkNamedElements(this.pIdentifierPatterns, false);
        if (!this.pSkipComments) {
            this.checkComments(this.pIdentifierPatterns);
        }
        this.checkFileNames(this.pIdentifierPatterns, false);
        if (!this.pSkipStringLiterals) {
            this.checkStringLiterals(this.pIdentifierPatterns, false);
        }
        this.checkMacroNames(this.pIdentifierPatterns, false);
        if (this.pCheckInactiveCode) {
            this.checkInsideInactiveCode(this.pIdentifierPatterns, false, null);
        }
    }

    @Override
    protected void checkMacroName(VlogMacroInfo macro, HashSet<Pattern> patterns, boolean onlyFullNameMatch) {
        if (patterns != null && !patterns.isEmpty()) {
            super.checkMacroName(macro, patterns, onlyFullNameMatch);
        }
        if (this.bannedWords.isEmpty()) {
            return;
        }
        if (this.bannedWords.contains(macro.getName())) {
            this.addHit(macro.getMacroParserPath(), macro.getLine(), "The macro name '" + macro.getName() + "' is a banned word!", null);
        }
    }

    @Override
    protected void checkInactiveString(String string, ParserPath path, int currLine, HashSet<Pattern> patterns, boolean onlyFullNameMatch) {
        String[] words;
        if (patterns != null && !patterns.isEmpty()) {
            super.checkInactiveString(string, path, currLine, patterns, onlyFullNameMatch);
        }
        if (this.bannedWords.isEmpty()) {
            return;
        }
        String[] stringArray = words = WORD_DELIMITER.split(string);
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (this.bannedWords.contains(word)) {
                this.addHit(path, currLine, "Inactive code content '" + string + "' is a banned word", null);
            }
            ++n2;
        }
    }

    @Override
    protected void checkNamedElement(RfNamedElement namedElement, HashSet<Pattern> patterns, boolean onlyFullNameMatch) {
        if (patterns != null && !patterns.isEmpty()) {
            super.checkNamedElement(namedElement, patterns, onlyFullNameMatch);
        }
        if (this.bannedWords.isEmpty()) {
            return;
        }
        String elementName = namedElement.getName();
        if (this.bannedWords.contains(elementName)) {
            this.addHit(namedElement, "The name of " + LintUtils.getElementKind(namedElement) + " '" + LintUtils.getNamedElementFullName(namedElement) + "' is a banned word!");
        }
    }

    @Override
    protected void checkComment(ParserPath path, String comment, int commentLine, HashSet<Pattern> patterns) {
        if (patterns != null && !patterns.isEmpty()) {
            super.checkComment(path, comment, commentLine, patterns);
        }
        if (this.bannedWords.isEmpty()) {
            return;
        }
        String[] commentsByLine = LINE_DELIMITER.split(comment);
        int currLine = commentLine;
        String[] stringArray = commentsByLine;
        int n = commentsByLine.length;
        int n2 = 0;
        while (n2 < n) {
            String[] words;
            String line = stringArray[n2];
            String[] stringArray2 = words = WORD_DELIMITER.split(line);
            int n3 = words.length;
            int n4 = 0;
            while (n4 < n3) {
                String word = stringArray2[n4];
                if (this.bannedWords.contains(word)) {
                    this.addHit(path, currLine, "Comment line \"" + line.trim() + "\" contains banned word '" + word + "'!", null);
                }
                ++n4;
            }
            ++currLine;
            ++n2;
        }
    }

    @Override
    protected void checkFileName(ParserPath path, String fileName, HashSet<Pattern> patterns, boolean onlyFullNameMatch) {
        if (patterns != null && !patterns.isEmpty()) {
            super.checkFileName(path, fileName, patterns, onlyFullNameMatch);
        }
        if (this.bannedWords.isEmpty()) {
            return;
        }
        String nameWithoutExtensions = fileName;
        int firstPeriod = fileName.lastIndexOf(46);
        if (firstPeriod != -1) {
            nameWithoutExtensions = fileName.substring(0, firstPeriod);
        }
        if (this.bannedWords.contains(nameWithoutExtensions)) {
            this.addHit(path, 0, "File " + fileName + " is a banned word!", null);
        }
    }

    @Override
    protected void checkStringLiteral(ParserPath path, String literal, HidOperator operator, HashSet<Pattern> patterns, boolean onlyFullNameMatch) {
        String[] words;
        if (patterns != null && !patterns.isEmpty()) {
            super.checkStringLiteral(path, literal, operator, patterns, onlyFullNameMatch);
        }
        if (this.bannedWords.isEmpty()) {
            return;
        }
        String[] stringArray = words = WORD_DELIMITER.split(literal);
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (this.bannedWords.contains(word)) {
                this.addHit(path, (HidOccurrence)operator.getOccurrence(), "String literal \"" + literal + "\" contains banned word '" + word + "'!", true);
            }
            ++n2;
        }
    }
}

