/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.27.2.0")
@CheckName(value="SVTB.27.2.0")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.CLASS})
@CheckTitle(value="Class suffix based on inheritance")
@CheckDescription(value="All classes that inherit from <baseClass> should have a <suffix> suffix.\n\nExamples for baseClass='a' and suffix='_child':\nclass a;\nendclass\nclass my_class extends a; // not allowed\nendclass\nclass test_child extends a; // allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_2_0
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Check all classes that inherit from 'baseClass'.", name="baseClass", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.STRING)
    private String pBaseClassValue;
    @CheckParameter(defaultValue="", description="If specified, the suffix is checked only if 'typeParamName' 'typeParamEquals' 'typeParamValue'. For example to distinguish between physical and virtual uvm_sequencers.", name="typeParamName", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pTypeParamNameValue;
    @CheckParameter(defaultValue="true", description="Relevant only if typeParamName is specified.", name="typeParamEquals", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pTypeParamEqualsValue;
    @CheckParameter(defaultValue="true", description="Relevant only if typeParamName is specified.", name="typeParamValue", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pTypeParamValueValue;
    @CheckParameter(defaultValue="", description="Comma separated list to filter inheritance subtrees out of the 'baseClass' inheritance tree.", name="skipBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipBaseClassesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of allowed 'suffixes'.", name="suffix", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSuffixValue;
    @CheckParameter(defaultValue="", description="Comma separated list of legal name exceptions. For example short names like 'env' for a class that inherits from 'uvm_env', instead of a suffixed name.", name="classNameExceptions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pClassNameExceptionsValue;

    public Check_SVTB_27_2_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass baseClass = this.fOVMProject.getRfProject().getClass(this.pBaseClassValue, true);
        if (baseClass == null) {
            this.addHit(null, "Class '" + this.pBaseClassValue + "' not found!");
            return;
        }
        HashSet<RfClass> visited = new HashSet<RfClass>();
        visited.add(baseClass);
        this.checkClassSuffix(baseClass.getChildren(), visited);
    }

    void checkClassSuffix(RfClass aClass, Set<RfClass> visited) {
        RfFileDef classFile;
        if (aClass == null) {
            return;
        }
        if (this.pSkipBaseClassesValue != null && this.pSkipBaseClassesValue.contains(aClass.getFullName())) {
            return;
        }
        this.notifyCheckAlive();
        this.checkClassSuffix(aClass.getChildren(), visited);
        if (this.pTypeParamNameValue != null && !this.pTypeParamNameValue.isEmpty()) {
            RfField param = aClass.getParameterWithPrefix(this.pTypeParamNameValue, 256, 1, 2);
            if (param == null) {
                if (this.pTypeParamEqualsValue) {
                    return;
                }
            } else {
                String paramType = param.getAssociatedTypeName();
                if (this.pTypeParamEqualsValue && !this.pTypeParamValueValue.equals(paramType) || !this.pTypeParamEqualsValue && this.pTypeParamValueValue.equals(paramType)) {
                    return;
                }
            }
        }
        if ((classFile = aClass.getFile()) != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(classFile.getParserPath(), this)) {
            return;
        }
        String className = aClass.getName();
        String classFullName = aClass.getFullName();
        if (!(className == null || this.pClassNameExceptionsValue != null && this.pClassNameExceptionsValue.contains(className))) {
            boolean foundSuffix = false;
            for (String suffix : this.pSuffixValue) {
                if (!className.endsWith(suffix)) continue;
                foundSuffix = true;
                break;
            }
            if (!foundSuffix) {
                this.addHit(aClass, "Class '" + classFullName + "' does not end with '" + this.pSuffixValue + "'!");
            }
        }
    }

    void checkClassSuffix(Collection<RfClass> aClasses, Set<RfClass> visited) {
        if (aClasses == null) {
            return;
        }
        for (RfClass eachClass : aClasses) {
            if (visited.contains(eachClass)) continue;
            visited.add(eachClass);
            this.checkClassSuffix(eachClass, visited);
        }
    }
}

