/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.ClassMembersIterator;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1.4")
@CheckID(value="SVTB.27.3.0")
@CheckName(value="SVTB.27.3.0")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.CLASS, RuleLabel.FIELD})
@CheckTitle(value="Class member naming pattern")
@CheckDescription(value="All memberKinds class members must have a nameMinLength minimum length and match the namePattern pattern.\n\nExamples for namePattern='example_.*' and nameMinLength='4':\nclass a;\n\tint example_field1; // allowed\n\tint field2; // not allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_3_0
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="field, function, task, constraint, event, covergroup, type_parameter", description="Comma separated list of field, function, task, constraint, event, covergroup, type_parameter.", name="memberKinds", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pMemberKindsValue;
    @CheckParameter(defaultValue="", description="The member name pattern.", name="namePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pNamePatternValue;
    @CheckParameter(defaultValue="1", description="The member name minimal length.", name="nameMinLength", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private int pNameMinLengthValue;
    @CheckParameter(defaultValue="", description="Comma separated list of macro prefixes, for example uvm_.", name="skipMembersDeclaredInsideMacrosWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipMembersDeclaredInsideMacrosWithPrefixesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of class prefixes, for example uvm_pkg::uvm_.", name="skipMembersDeclaredInsideClassesWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipMembersDeclaredInsideClassesWithPrefixesValue;

    public Check_SVTB_27_3_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.pMemberKindsValue == null || this.pMemberKindsValue.isEmpty()) {
            this.signalParamError("Parameter 'memberKinds' not specified!", false);
            return;
        }
        for (RfClass eachClass : this.fOVMProject.getAllClasses()) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(eachClass.getFile())) continue;
            ClassMembersIterator classMembersIterator = new ClassMembersIterator(eachClass, this.pMemberKindsValue, true, this.pSkipMembersDeclaredInsideMacrosWithPrefixesValue, this.pSkipMembersDeclaredInsideClassesWithPrefixesValue);
            while (classMembersIterator.hasNext()) {
                RfNamedElement eachMember = classMembersIterator.next();
                if (eachMember == null || eachMember instanceof RfField var5_5 && field.isFromEmbeddedCovergroupDef() || (memberName = eachMember.getName()) == null) continue;
                if (memberName.length() < this.pNameMinLengthValue) {
                    this.addHit(eachMember, "The name length of " + LintUtils.getElementKind(eachMember) + " '" + LintUtils.getNamedElementFullName(eachMember) + "' is " + memberName.length() + ", less than the allowed size of " + this.pNameMinLengthValue + "!");
                    continue;
                }
                if (this.pNamePatternValue.pattern().isEmpty() || (m = this.pNamePatternValue.matcher(memberName)).matches()) continue;
                this.addHit(eachMember, "The name of " + LintUtils.getElementKind(eachMember) + " '" + LintUtils.getNamedElementFullName(eachMember) + "' does not follow the allowed pattern!");
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

