/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_27_3_1;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.27.3.1")
@CheckName(value="SVTB.27.3.1")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.FIELD})
@CheckTitle(value="Name member variables with an m_ prefix")
@CheckDescription(value="Having a prefix for class member variables disambiguates assignments to members.\nIt makes it easy to determine if a variable is a class member or a function member.\n...\nint m_my_int;\n...\nfunction void set_my_int(int my_int);\n  m_my_int = my_int;\nendfunction: set_my_int\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_27_3_1.class)
public class Check_SVTB_27_3_1
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="constant", description="Comma separated list of elements to be skipped.", name="skipElements", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipElementKinds;
    @CheckParameter(defaultValue="", description="Comma separated list of element name patterns to be skipped.", name="skipElementNames", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private Set<Pattern> pSkipElementNames;
    @CheckParameter(defaultValue="false", description="When true, only local members are checked. Has priority over <checkedVisibilities> parameter.", name="checkOnlyLocal", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckOnlyLocal;
    @CheckParameter(defaultValue="public, local, protected", description="Comma separated list of visibilities of members to be checked.", name="checkedVisibilities", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pCheckedVisibilities;

    public Check_SVTB_27_3_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement classs : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            RfFileDef file = classs.getFile();
            if (file == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) continue;
            List<RfField> fields = classs.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            List<RfField> events = classs.getEventsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (events != null && !events.isEmpty()) {
                fields.addAll(events);
            }
            for (RfField field : fields) {
                if (this.pCheckOnlyLocal && !field.isPrivate() || this.pSkipElementKinds.contains("constant") && field.isConst() || !this.pCheckedVisibilities.contains("public") && field.isPublic() || !this.pCheckedVisibilities.contains("local") && field.isPrivate() || !this.pCheckedVisibilities.contains("protected") && field.isProtected() || field.isFromEmbeddedCovergroupDef()) continue;
                String fieldName = field.getName();
                boolean matches = false;
                for (Pattern pattern : this.pSkipElementNames) {
                    if (!pattern.matcher(fieldName).matches()) continue;
                    matches = true;
                    break;
                }
                if (matches || fieldName.startsWith("m_")) continue;
                this.addHit(field, "Member variable '" + field.getName() + "' of class '" + classs.getName() + "' does not start with m_!", new VerissimoAutofixAdditionalInfo(field));
            }
        }
    }

    @Override
    public String getAdditionalInfoForDisplayString(OVMComplianceCheckHit hit) {
        VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
        if (additionalInfo == null) {
            return null;
        }
        Object element = additionalInfo.getElement();
        if (!(element instanceof RfNamedElement)) {
            return null;
        }
        return String.valueOf(LintUtils.getElementKind((RfNamedElement)element)) + " '" + ((RfNamedElement)element).getName() + "'";
    }
}

