/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.ClassMembersIterator;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1.6")
@CheckID(value="SVTB.27.3.2")
@CheckName(value="SVTB.27.3.2")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.CLASS, RuleLabel.FIELD})
@CheckTitle(value="Class field naming pattern if field type is class")
@CheckDescription(value="All class fields of type class that inherit from baseClassPattern should have a name that matches namePattern.\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_3_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="For all classes that inherit from a class that has a name matching baseClassPattern.", name="baseClassPattern", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.REGEX)
    private Pattern pBaseClassPatternValue;
    @CheckParameter(defaultValue="", description="Skip classes that inherit from a class that has a name matching skipBaseClassPattern.", name="skipBaseClassPattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pSkipBaseClassPatternValue;
    @CheckParameter(defaultValue="", description="Check the namePattern.", name="namePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pNamePatternValue;
    @CheckParameter(defaultValue="", description="If specified, the pattern is checked only if typeParamName typeParamEquals typeParamValue. For example to distinguish between physical and virtual uvm_sequencers.", name="typeParamName", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pTypeParamNameValue;
    @CheckParameter(defaultValue="true", description="Relevant only if typeParamName is specified.", name="typeParamEquals", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pTypeParamEqualsValue;
    @CheckParameter(defaultValue="true", description="Relevant only if typeParamName is specified.", name="typeParamValue", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pTypeParamValueValue;

    public Check_SVTB_27_3_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.pTypeParamNameValue == null) {
            this.pTypeParamNameValue = "";
        }
        if (!this.pTypeParamNameValue.isEmpty() && (this.pTypeParamValueValue == null || this.pTypeParamValueValue.isEmpty())) {
            this.addHit(null, "Rule parameter 'typeParamValue' not specified!");
            return;
        }
        NullProtectedList<RfClass> allClasses = this.fOVMProject.getAllClasses();
        if (allClasses.isEmpty()) {
            return;
        }
        HashMap<String, RfClass> baseClasses = new HashMap<String, RfClass>();
        HashMap<String, RfClass> skipBaseClasses = new HashMap<String, RfClass>();
        for (RfClass eachClass : allClasses) {
            Matcher m = this.pBaseClassPatternValue.matcher(eachClass.getFullName());
            if (m.matches()) {
                baseClasses.put(eachClass.getFullName(), eachClass);
            }
            if (this.pSkipBaseClassPatternValue.pattern().isEmpty() || !(m = this.pSkipBaseClassPatternValue.matcher(eachClass.getFullName())).matches()) continue;
            skipBaseClasses.put(eachClass.getFullName(), eachClass);
        }
        if (baseClasses.isEmpty()) {
            return;
        }
        HashSet<String> classMembersIteratorKeys = new HashSet<String>();
        classMembersIteratorKeys.add("field");
        for (RfClass eachClass : allClasses) {
            this.notifyCheckAlive();
            RfFileDef classFile = eachClass.getFile();
            if (classFile != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(classFile.getParserPath(), this)) continue;
            ClassMembersIterator classMembersIterator = new ClassMembersIterator(eachClass, classMembersIteratorKeys, true);
            while (classMembersIterator.hasNext()) {
                Matcher m;
                String memberName;
                RfField eachField;
                RfNamedElement fieldType;
                RfNamedElement eachMember = classMembersIterator.next();
                if (eachMember == null || !(eachMember instanceof RfField) || (fieldType = LintUtils.getAssociatedFinalType(eachField = (RfField)eachMember)) == null || !(fieldType instanceof RfClass) || !LintUtils.isClassEqualOrChildOf((RfClass)fieldType, baseClasses) || !skipBaseClasses.isEmpty() && LintUtils.isClassEqualOrChildOf((RfClass)fieldType, skipBaseClasses)) continue;
                if (this.pTypeParamNameValue != null && !this.pTypeParamNameValue.isEmpty()) {
                    String paramType;
                    RfField param = eachClass.getParameterWithPrefix(this.pTypeParamNameValue, 256, 1, 2);
                    if (!this.pTypeParamEqualsValue ? param != null && this.pTypeParamValueValue.equals(paramType = param.getAssociatedTypeName()) : param == null || !this.pTypeParamValueValue.equals(paramType = param.getAssociatedTypeName())) continue;
                }
                if ((memberName = eachMember.getName()) == null || this.pNamePatternValue.pattern().isEmpty() || (m = this.pNamePatternValue.matcher(memberName)).matches()) continue;
                this.addHit(eachMember, "Illegal class field name for '" + eachClass.getName() + "." + eachMember.getName() + "'!");
            }
        }
    }
}

