/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.ClassMembersIterator;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1.4")
@CheckID(value="SVTB.27.4.0")
@CheckName(value="SVTB.27.4.0")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.CLASS, RuleLabel.METHOD, RuleLabel.ARGUMENT})
@CheckTitle(value="Class method arguments naming pattern")
@CheckDescription(value="All class method arguments must match the namePattern pattern.")
public class Check_SVTB_27_4_0
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of macro prefixes, for example uvm_.", name="memberKinds", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pMemberKindsValue;
    @CheckParameter(defaultValue="", description="The member name pattern.", name="namePattern", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.REGEX)
    private Pattern pNamePatternValue;
    @CheckParameter(defaultValue="", description="Comma separated list of macro prefixes, for example uvm_.", name="skipMethodsDeclaredInsideMacrosWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipMethodsDeclaredInsideMacrosWithPrefixesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of class prefixes, for example uvm_pkg::uvm_.", name="skipMethodsDeclaredInsideClassesWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipMethodsDeclaredInsideClassesWithPrefixesValue;

    public Check_SVTB_27_4_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.pMemberKindsValue.isEmpty()) {
            this.pMemberKindsValue.add("constructor");
            this.pMemberKindsValue.add("function");
            this.pMemberKindsValue.add("task");
        }
        for (RfNamedElement eachClass : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            if (eachClass == null || !(eachClass instanceof RfClass)) continue;
            ClassMembersIterator classMembersIterator = new ClassMembersIterator((RfClass)eachClass, this.pMemberKindsValue, true, this.pSkipMethodsDeclaredInsideMacrosWithPrefixesValue, this.pSkipMethodsDeclaredInsideClassesWithPrefixesValue);
            while (classMembersIterator.hasNext()) {
                RfNamedElement eachMember = classMembersIterator.next();
                if (eachMember == null) continue;
                String memberInfo = String.valueOf(eachClass.getName()) + "." + eachMember.getName() + "()";
                List<RfField> arguments = eachMember.getArgumentsWithPrefix("", 2);
                if (arguments == null || arguments.isEmpty()) continue;
                for (RfField argument : arguments) {
                    Matcher m;
                    if (argument == null) continue;
                    String argumentName = argument.getName();
                    if (this.pNamePatternValue.pattern().isEmpty() || (m = this.pNamePatternValue.matcher(argumentName)).matches()) continue;
                    this.addHit(eachMember, "Argument '" + argumentName + "'' of '" + memberInfo + "' doesn't match the name pattern!");
                }
            }
        }
    }
}

