/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_27_5_1;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCoverbin;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.semantic.extension.IRfHidOperatorLayer;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.27.5.1")
@CheckName(value="SVTB.27.5.1")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Lower case letters with underscore")
@CheckDescription(value="All elements must be named with uncapitalized letters.\nUse the underscore '_' for spacing. This standard is aligned with typical Verilog code along with the industry standard open source OVM, VMM and UVM code.\n\nAllowed: my_class\nNot Allowed: MyClass\nNot Recommended: myclass\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckAutofix(value=Autofix_SVTB_27_5_1.class)
public class Check_SVTB_27_5_1
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="parameter, localparam, specparam, typeparam, enum_item, constant", description="Skip elements of type covergroup, coverpoint, property, sequence, assert, cover, assume, covercross, bins, illegal_bins, ignore_bins, parameter, localparam, specparam, typeparam, struct_member, union_member, enum_item, constant, port, net. Comma separated list.", name="skipElements", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipElementsValue;
    @CheckParameter(defaultValue="", description="Comma separated list of patterns to allow naming exceptions.", name="skipPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private Set<Pattern> pSkipPatterns;

    public Check_SVTB_27_5_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(namedElement -> {
            if (!this.pSkipPatterns.isEmpty()) {
                for (Pattern pattern : this.pSkipPatterns) {
                    if (!Pattern.matches(pattern.toString(), namedElement.getName())) continue;
                    return true;
                }
            }
            if (namedElement.isPredefined()) {
                return true;
            }
            if (namedElement.isAnonymous()) {
                return true;
            }
            if (namedElement instanceof RfActionBlock) {
                return true;
            }
            if (namedElement instanceof RfStruct) {
                return true;
            }
            if (namedElement instanceof RfCoverbin) {
                return true;
            }
            if (namedElement instanceof RfCovergroup && namedElement.getEnclosingScope() instanceof RfClass) {
                return true;
            }
            this.notifyCheckAlive();
            if (this.checkPreWaivers(namedElement.getFile())) {
                return true;
            }
            if (namedElement instanceof RfCoverpoint) {
                this.addHitsForBinsInCoveragePoint(namedElement);
            }
            if (namedElement instanceof RfField) {
                if ((((RfField)namedElement).isEnumElement() || ((RfField)namedElement).isEnumRangeElement()) && this.pSkipElementsValue.contains("enum_item")) {
                    return true;
                }
                RfNamedElement enclosingScope = namedElement.getEnclosingScope();
                if (enclosingScope instanceof RfStruct && !((RfField)namedElement).isEnumElement()) {
                    if (((RfStruct)enclosingScope).isStruct() && this.pSkipElementsValue.contains("struct_member")) {
                        return true;
                    }
                    if (((RfStruct)enclosingScope).isUnion() && this.pSkipElementsValue.contains("union_member")) {
                        return true;
                    }
                }
                if (((RfField)namedElement).isParameter() && this.pSkipElementsValue.contains("parameter")) {
                    return true;
                }
                if (((RfField)namedElement).isLocalParameter() && this.pSkipElementsValue.contains("localparam")) {
                    return true;
                }
                if (((RfField)namedElement).isTypeParameter() && this.pSkipElementsValue.contains("typeparam")) {
                    return true;
                }
                if (((RfField)namedElement).isSpecParam() && this.pSkipElementsValue.contains("specparam")) {
                    return true;
                }
                if (namedElement.isConst() && this.pSkipElementsValue.contains("constant")) {
                    return true;
                }
                if (((RfField)namedElement).isNet() && this.pSkipElementsValue.contains("net")) {
                    return true;
                }
                if (((RfField)namedElement).isFromEmbeddedCovergroupDef() && this.pSkipElementsValue.contains("covergroup")) {
                    return true;
                }
            }
            if (this.pSkipElementsValue.contains(namedElement.getKindName())) {
                return true;
            }
            if (this.pSkipElementsValue.contains("port") && namedElement instanceof RfPort) {
                return true;
            }
            if (this.containsUppercase(namedElement.getName())) {
                this.addHit(namedElement, "Upper case letters used in identifier '" + namedElement.getName() + "' !", new VerissimoAutofixAdditionalInfo(namedElement));
            }
            return true;
        });
    }

    public void addHitsForBinsInCoveragePoint(RfNamedElement scope) {
        scope.visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

            public boolean visit(HidOperator operator) {
                IHidObject obj;
                if (!(operator instanceof IRfHidOperatorLayer)) {
                    return true;
                }
                IRfHidOperatorLayer hidOperator = (IRfHidOperatorLayer)operator;
                if (!(hidOperator.isBins() || hidOperator.isIllegalBins() || hidOperator.isIgnoreBins())) {
                    return true;
                }
                if (hidOperator.isIllegalBins() && Check_SVTB_27_5_1.this.pSkipElementsValue.contains("illegal_bins")) {
                    return true;
                }
                if (hidOperator.isIgnoreBins() && Check_SVTB_27_5_1.this.pSkipElementsValue.contains("ignore_bins")) {
                    return true;
                }
                if (hidOperator.isBins() && Check_SVTB_27_5_1.this.pSkipElementsValue.contains("bins")) {
                    return true;
                }
                IHidObject iHidObject = obj = hidOperator.getLHValue() instanceof RfHidImplicit && ((RfHidImplicit)hidOperator.getLHValue()).isLiteralWildcard() ? hidOperator.getFirstRHValue() : hidOperator.getLHValue();
                RfHidImplicit lhValue = obj instanceof RfHidOperator ? (((RfHidOperator)obj).getLHValue() instanceof RfHidImplicit ? (RfHidImplicit)((RfHidOperator)obj).getLHValue() : null) : (obj instanceof RfHidImplicit ? (RfHidImplicit)obj : null);
                if (lhValue == null) {
                    return true;
                }
                if (Check_SVTB_27_5_1.this.containsUppercase(lhValue.getName())) {
                    Check_SVTB_27_5_1.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "Upper case letters used in identifier '" + lhValue.getName() + "' !", new VerissimoAutofixAdditionalInfo(hidOperator));
                }
                return true;
            }
        });
    }

    private boolean containsUppercase(String text) {
        if (text == null) {
            return false;
        }
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (ch != '_' && ch != '$' && ch != '\\' && Character.isUpperCase(ch)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String getAdditionalInfoForDisplayString(OVMComplianceCheckHit hit) {
        VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
        if (additionalInfo == null) {
            return null;
        }
        Object element = additionalInfo.getElement();
        if (element instanceof RfNamedElement) {
            return String.valueOf(LintUtils.getElementKind((RfNamedElement)element)) + " '" + ((RfNamedElement)element).getName() + "'";
        }
        if (element instanceof IRfHidOperatorLayer) {
            String displayString;
            IRfHidOperatorLayer hidOperator = (IRfHidOperatorLayer)element;
            if (hidOperator.isIllegalBins()) {
                displayString = "illegal bin";
            } else if (hidOperator.isIgnoreBins()) {
                displayString = "ignore bin";
            } else if (hidOperator.isBins()) {
                displayString = "bin";
            } else {
                return null;
            }
            if (!(hidOperator.getLHValue() instanceof RfHidImplicit)) {
                return null;
            }
            displayString = String.valueOf(displayString) + " '" + ((RfHidImplicit)hidOperator.getLHValue()).getName() + "'";
            return displayString;
        }
        return null;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

