/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractAllVariablesCheck;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.27.5.2")
@CheckName(value="SVTB.27.5.2")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Do not use long variable names")
@CheckDescription(value="A variable name should not be a sentence! It should be a shorthand description of what is contained.\nIf a variable name gets to long, it becomes difficult to use more than one variable in an operation on a single line of reasonable width.\n\nExamples:\nNot allowed: int m_number_of_opened_objects_in_system;\nAllowed: int m_num_open; // number of opened objects in system\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_5_2
extends AbstractAllVariablesCheck {
    @CheckParameter(defaultValue="16", description="The maximum allowed number of characters.", name="maxNofCharacters", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private int fMaxNofCharacters;

    public Check_SVTB_27_5_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void checkNamingConvention(RfNamedElement namedElement, Set<RfField> loopVariables) {
        if (namedElement.getName().length() > this.fMaxNofCharacters) {
            this.addHit(namedElement, "Variable '" + namedElement.getName() + "' has more than " + this.fMaxNofCharacters + " characters!");
        }
    }

    @Override
    protected Set<RfField> collectLoopVariables() {
        return new HashSet<RfField>();
    }
}

