/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.27.5.3")
@CheckName(value="SVTB.27.5.3")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Do not use reserved keywords of other languages")
@CheckDescription(value="Do not use reserved keywords of languages used in design process as user-defined identifiers.\nThis rule applies to:\n1) member variables of classes and structures;\n2) DPI function declarations;\n3) interface signal names;\nThese elements are often used to communicate across languages and eliminating reserved keywords will reduce the need for special exceptions and facilitate automatic translations.\n\nKeywords:\n C++\n   __abstract, abstract, __alignof, array, __asm, __assume, __based, bool, __box, break, case, catch, __cdecl, char, class, const, const_cast, continue, __declspec, default, __delegate, delegate, delete, deprecated, dllexport, dllimport, do, double, dynamic_cast, else, enum, event, __event, __except, explicit, extern, false, __fastcall, __finally, finally, float, for, each, in, __forceinline, friend, friend_as, __gc, gcnew, generic, goto, __hook, __identifier, if, __if_exists, __if_not_exists, initonly, __inline, inline, int, __int8, __int16, __int32, __int64, __interface, interface, interior_ptr, __leave, literal, long, __m64, __m128, __m128d, __m128i, __multiple_inheritance, mutable, naked, namespace, new, __nogc, noinline, __noop, noreturn, nothrow, novtable, nullptr, operator, __pin, private,__property, property, protected, public, __raise, ref, register, reinterpret_cast, return, safecast, __sealed, sealed, selectany, short, signed, __single_inheritance, sizeof, static, static_cast, __stdcall, struct, __super, switch, template, this, thread, throw, true, try, __try, __except, __finally, __try_cast, typedef, typeid, typename, __unaligned, __unhook, union, unsigned, using, uuid, __uuidof, value, __value, virtual, __virtual_inheritance, void, volatile,__w64, __wchar_t, wchar_t, while\n\n PERL\n   if, unless, else, elsif, while, until, for, each, foreach, next, last, break, continue, return, use, no, require, my, our, local, BEGIN, END, require, package, sub, do, __END__, __DATA__, __FILE__, __LINE__, __PACKAGE__, and, or, not, eq, ne, lt, gt, le, ge, cmp, abs, accept, alarm, atan2, bind, binmode, bless, caller, chdir, chmod, chomp, chop, chown, chr, chroot, close, closedir, connect, cos, crypt, dbmclose, dbmopen, defined, delete, die, dump, endgrent, endhostent, endnetent, endprotoent, endpwent, endservent, eof, eval, exec, exists, exit, exp, fcntl, fileno, flock, fork, format, formline, getc, getgrent, getgrgid, getgrnam, gethostbyaddr, gethostbyname, gethostent, getlogin, getnetbyaddr, getnetbyname, getnetent, getpeername, getpgrp, getppid, getpriority,getprotobyname, getprotobynumber, getprotoent, getpwent, getpwnam, getpwuid, getservbyname, getservbyport, getservent, getsockname, getsockopt, glob, gmtime, goto, grep, hex, import, index, ioctl, join, keys, kill, last, lc, lcfirst, length, link, listen, localtime, lock, log, lstat, map, mkdir, msgctl, msgget, msgrcv, msgsnd, oct, open, opendir, ord, pack, package, pipe, pop, pos, pr, prf, prototype, push, quotemeta, rand, read, readdir, readline, readlink, recv, redo, ref, rename, reset, return, reverse, rewinddir, rindex, rmdir, scalar, seek, seekdir, select, semctl, semget, semop, send, setgrent, sethostent, setnetent, setpgrp, setpriority, setprotoent, setpwent, setservent, setsockopt, shift, shmctl, shmget, shmread, shmwrite, shutdown, sin, sleep, socket, socketpair, sort,splice, split, sprf, sqrt, srand, stat, study, sub, substr, symlink, syscall, sysread, sysseek, system, syswrite, tell, telldir, tie, time, times, truncate, uc, ucfirst, umask, undef, unlink, unpack, unshift, untie, utime, values, vec, wait, waitpid, wantarray, warn, write, strict, english, warnings, vars, subs, utf8, sigtrap, locale, open, less, eger, filetest, constant,bytes, diagnostics\n\n SystemC\n   sensitive, dont_initialize, gen_unique_name, name, next_trigger, sc_assert_fail, sc_copyright, sc_cycle, sc_initialize, sc_simulation_time, sc_start, sc_stop, sc_get_default_time_unit, sc_get_default_time_resolution, sc_time_stamp, sc_version, timed_out, wait, sc_trace, sc_create_vcd_trace_file, sc_close_vcd_trace_file, SC_MODULE, SC_CTOR, SC_METHOD, SC_THREAD, sc_time_unit, sc_clock, sc_int, sc_uint, sc_bigint, sc_biguint, sc_logic, sc_lv, sc_bit, sc_bv, sc_fixed, sc_ufixed, sc_fixed_fast, sc_ufixed_fast, sc_fix, sc_ufix, sc_buffer, sc_fifo, sc_mutex, sc_semaphore, sc_signal, sc_signal_resolved, sc_signal_rv, sc_fifo_in_if, sc_fifo_out_if, sc_mutex_if, sc_semaphore_if, sc_signal_in_if, sc_signal_inout_if, sc_master, sc_inmaster, sc_outmaster, sc_inout_master, sc_indexed, sc_slave, sc_inslave, sc_outslave, sc_inoutslave, sc_in, sc_out,sc_inout, sc_noHandshake, sc_fullHandshake, sc_memfullHandshake, sc_enable_Handshake, sc_memenHandshake, sc_link_mp,sc_trace_file,\n\n VHDL\n   abs, access, after, alias, all, and, architecture, array, assert, attribute, begin, block, body, buffer, bus, case, component, configuration, constant, disconnect, downto, else, elsif, end, entity, exit, file, for, function, generate, generic, group, guarded, if, impure, in, inertial, inout, is, label, library, linkage, literal, loop, map, mod, nand, new, next, nor, not, null, of, on, open, or, others, out, package, port, postponed, procedure, process, pure, range, record, register, reject, return, rol, ror, select, severity, signal, shared, sla, sli, sra, srl, subtype, then, to, transport, type, unaffected, units, until, use, variable, wait, when, while, with, xnor, xor\n\nExamples:\nclass a;\n\tint getsockname; // not allowed\n\tint port; // not allowed\n\tint b; // allowed\nendclass\n")
public class Check_SVTB_27_5_3
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="If true, skip local and protected API.", name="skipLocalAndProtectedAPI", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    boolean pSkipLocalAndProtectedAPI;
    private static final HashSet<String> DEFAULT_LIST = new HashSet<String>(Arrays.asList("__abstract", "abstract", "__alignof", "array", "__asm", "__assume", "__based", "bool", "__box", "break", "case", "catch", "__cdecl", "char", "class", "const", "const_cast", "continue", "__declspec", "default", "__delegate", "delegate", "delete", "deprecated", "dllexport", "dllimport", "do", "double", "dynamic_cast", "else", "enum", "event", "__event", "__except", "explicit", "extern", "false", "__fastcall", "__finally", "finally", "float", "for", "each", "in", "__forceinline", "friend", "friend_as", "__gc", "gcnew", "generic", "goto", "__hook", "__identifier", "if", "__if_exists", "__if_not_exists", "initonly", "__inline", "inline", "int", "__int8", "__int16", "__int32", "__int64", "__interface", "interface", "interior_ptr", "__leave", "literal", "long", "__m64", "__m128", "__m128d", "__m128i", "__multiple_inheritance", "mutable", "naked", "namespace", "new", "__nogc", "noinline", "__noop", "noreturn", "nothrow", "novtable", "nullptr", "operator", "__pin", "private", "__property", "property", "protected", "public", "__raise", "ref", "register", "reinterpret_cast", "return", "safecast", "__sealed", "sealed", "selectany", "short", "signed", "__single_inheritance", "sizeof", "static", "static_cast", "__stdcall", "struct", "__super", "switch", "template", "this", "thread", "throw", "true", "try", "__try", "__except", "__finally", "__try_cast", "typedef", "typeid", "typename", "__unaligned", "__unhook", "union", "unsigned", "using", "uuid", "__uuidof", "value", "__value", "virtual", "__virtual_inheritance", "void", "volatile", "__w64", "__wchar_t", "wchar_t", "while", "if", "unless", "else", "elsif", "while", "until", "for", "each", "foreach", "next", "last", "break", "continue", "return", "use", "no", "require", "my", "our", "local", "BEGIN", "END", "require", "package", "sub", "do", "__END__", "__DATA__", "__FILE__", "__LINE__", "__PACKAGE__", "and", "or", "not", "eq", "ne", "lt", "gt", "le", "ge", "cmp", "abs", "accept", "alarm", "atan2", "bind", "binmode", "bless", "caller", "chdir", "chmod", "chomp", "chop", "chown", "chr", "chroot", "close", "closedir", "connect", "cos", "crypt", "dbmclose", "dbmopen", "defined", "delete", "die", "dump", "endgrent", "endhostent", "endnetent", "endprotoent", "endpwent", "endservent", "eof", "eval", "exec", "exists", "exit", "exp", "fcntl", "fileno", "flock", "fork", "format", "formline", "getc", "getgrent", "getgrgid", "getgrnam", "gethostbyaddr", "gethostbyname", "gethostent", "getlogin", "getnetbyaddr", "getnetbyname", "getnetent", "getpeername", "getpgrp", "getppid", "getpriority", "getprotobyname", "getprotobynumber", "getprotoent", "getpwent", "getpwnam", "getpwuid", "getservbyname", "getservbyport", "getservent", "getsockname", "getsockopt", "glob", "gmtime", "goto", "grep", "hex", "import", "index", "ioctl", "join", "keys", "kill", "last", "lc", "lcfirst", "length", "link", "listen", "localtime", "lock", "log", "lstat", "map", "mkdir", "msgctl", "msgget", "msgrcv", "msgsnd", "oct", "open", "opendir", "ord", "pack", "package", "pipe", "pop", "pos", "pr", "prf", "prototype", "push", "quotemeta", "rand", "read", "readdir", "readline", "readlink", "recv", "redo", "ref", "rename", "reset", "return", "reverse", "rewinddir", "rindex", "rmdir", "scalar", "seek", "seekdir", "select", "semctl", "semget", "semop", "send", "setgrent", "sethostent", "setnetent", "setpgrp", "setpriority", "setprotoent", "setpwent", "setservent", "setsockopt", "shift", "shmctl", "shmget", "shmread", "shmwrite", "shutdown", "sin", "sleep", "socket", "socketpair", "sort", "splice", "split", "sprf", "sqrt", "srand", "stat", "study", "sub", "substr", "symlink", "syscall", "sysread", "sysseek", "system", "syswrite", "tell", "telldir", "tie", "time", "times", "truncate", "uc", "ucfirst", "umask", "undef", "unlink", "unpack", "unshift", "untie", "utime", "values", "vec", "wait", "waitpid", "wantarray", "warn", "write", "strict", "english", "warnings", "vars", "subs", "utf8", "sigtrap", "locale", "open", "less", "eger", "filetest", "constant", "bytes", "diagnostics", "sensitive", "dont_initialize", "gen_unique_name", "name", "next_trigger", "sc_assert_fail", "sc_copyright", "sc_cycle", "sc_initialize", "sc_simulation_time", "sc_start", "sc_stop", "sc_get_default_time_unit", "sc_get_default_time_resolution", "sc_time_stamp", "sc_version", "timed_out", "wait", "sc_trace", "sc_create_vcd_trace_file", "sc_close_vcd_trace_file", "SC_MODULE", "SC_CTOR", "SC_METHOD", "SC_THREAD", "sc_time_unit", "sc_clock", "sc_int", "sc_uint", "sc_bigint", "sc_biguint", "sc_logic", "sc_lv", "sc_bit", "sc_bv", "sc_fixed", "sc_ufixed", "sc_fixed_fast", "sc_ufixed_fast", "sc_fix", "sc_ufix", "sc_buffer", "sc_fifo", "sc_mutex", "sc_semaphore", "sc_signal", "sc_signal_resolved", "sc_signal_rv", "sc_fifo_in_if", "sc_fifo_out_if", "sc_mutex_if", "sc_semaphore_if", "sc_signal_in_if", "sc_signal_inout_if", "sc_master", "sc_inmaster", "sc_outmaster", "sc_inout_master", "sc_indexed", "sc_slave", "sc_inslave", "sc_outslave", "sc_inoutslave", "sc_in", "sc_out", "sc_inout", "sc_noHandshake", "sc_fullHandshake", "sc_memfullHandshake", "sc_enable_Handshake", "sc_memenHandshake", "sc_link_mp", "sc_trace_file", "accept_on", "alias", "always_com", "always_comb", "always_ff", "always_latch", "and", "assert", "assign", "assume", "automatic", "before", "begin", "bind", "bins", "binsof", "bit", "break", "buf", "bufif0", "bufif1", "byte", "case", "casex", "casez", "cell", "chandle", "checker", "class", "clocking", "cmos", "config", "const", "constraint", "context", "continue", "cover", "covergroup", "coverpoint", "cross", "deassign", "default", "defparam", "design", "disable", "dist", "do", "edge", "else", "end", "endcase", "endchecker", "endclass", "endclocking", "endconfig", "endfunction", "endgenerate", "endgroup", "endinterface", "endmodule", "endpackage", "endprimitive", "endprogram", "endproperty", "endspecify", "endsequence", "endtable", "endtask", "enum", "event", "eventually", "expect", "export", "extends", "extern", "final", "first_match", "for", "force", "foreach", "forever", "fork", "forkjoin", "function", "generate", "genvar", "global", "highz0", "highz1", "if", "iff", "ifnone", "ignore_bins", "illegal_bins", "implies", "import", "incdir", "include", "initial", "inout", "input", "inside", "instance", "int", "integer", "interface", "intersect", "join", "join_any", "join_none", "large", "let", "liblist", "library", "local", "localparam", "logic", "longint", "macromodule", "matches", "medium", "modport", "module", "nand", "negedge", "new", "nexttime", "nmos", "nor", "noshowcancelled", "not", "notif0", "notif1", "null", "or", "output", "package", "packed", "parameter", "pmos", "posedge", "primitive", "priority", "program", "property", "protected", "pull0", "pull1", "pulldown", "pullup", "pulsestyle_ondetect", "pulsestyle_onevent", "pure", "rand", "randc", "randcase", "randsequence", "rcmos", "real", "realtime", "ref", "reg", "reject_on", "release", "repeat", "restrict", "return", "rnmos", "rpmos", "rtran", "rtranif0", "rtranif1", "s_always", "s_eventually", "s_nexttime", "s_until", "s_until_with", "scalared", "sequence", "shortint", "shortreal", "showcancelled", "signed", "small", "solve", "specify", "specparam", "static", "string", "strong", "strong0", "strong1", "struct", "super", "supply0", "supply1", "sync_accept_on", "sync_reject_on", "table", "tagged", "task", "this", "throughout", "time", "timeprecision", "timeunit", "tran", "tranif0", "tranif1", "tri", "tri0", "tri1", "triand", "trior", "trireg", "type", "typedef", "union", "unique", "unique0", "unsigned", "until", "until_with", "untyped", "use", "uwire", "var", "vectored", "virtual", "void", "wait", "wait_order", "wand", "weak", "weak0", "weak1", "while", "wildcard", "wire", "with", "within", "wor", "xnor", "xor", "abs", "access", "after", "alias", "all", "and", "architecture", "array", "assert", "attribute", "begin", "block", "body", "buffer", "bus", "case", "component", "configuration", "constant", "disconnect", "downto", "else", "elsif", "end", "entity", "exit", "file", "for", "function", "generate", "generic", "group", "guarded", "if", "impure", "in", "inertial", "inout", "is", "label", "library", "linkage", "literal", "loop", "map", "mod", "nand", "new", "next", "nor", "not", "null", "of", "on", "open", "or", "others", "out", "package", "port", "postponed", "procedure", "process", "pure", "range", "record", "register", "reject", "return", "rol", "ror", "select", "severity", "signal", "shared", "sla", "sli", "sra", "srl", "subtype", "then", "to", "transport", "type", "unaffected", "units", "until", "use", "variable", "wait", "when", "while", "with", "xnor", "xor"));

    public Check_SVTB_27_5_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfField> fields;
        HashSet<String> reservedWords = DEFAULT_LIST;
        NullProtectedList<RfNamedElement> functions = new NullProtectedList<RfNamedElement>();
        functions.addAll(this.fOVMProject.getAllFunctions());
        functions.addAll(this.fOVMProject.getAllTasks());
        for (RfNamedElement function : functions) {
            this.notifyCheckAlive();
            if (!((RfFunction)function).isDPI()) continue;
            if (reservedWords.contains(function.getName())) {
                this.addHit(function, "DPI function '" + function.getName() + "' is a reserved keyword in other languages!");
            }
            if (!reservedWords.contains(((RfFunction)function).getCIdentifier())) continue;
            this.addHit(function, "DPI function '" + ((RfFunction)function).getCIdentifier() + "' is a reserved keyword in other languages!");
        }
        for (RfNamedElement interf : this.fOVMProject.getAllInterfaces()) {
            this.notifyCheckAlive();
            fields = interf.getLocalFields();
            if (fields == null) continue;
            for (RfField field : fields) {
                if (!(field instanceof RfPort) || !reservedWords.contains(field.getName())) continue;
                this.addHit(field, "Signal '" + field.getName() + "' is a reserved keyword in other languages!");
            }
        }
        for (RfStruct struct : this.fOVMProject.getAllStructs()) {
            this.notifyCheckAlive();
            fields = struct.getFields();
            if (fields == null) continue;
            for (RfField field : fields) {
                if (!reservedWords.contains(field.getName())) continue;
                this.addHit(field, "Field '" + field.getName() + "' is a reserved keyword in other languages!");
            }
        }
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            fields = clazz.getFields();
            if (fields == null) continue;
            for (RfField field : fields) {
                if (this.pSkipLocalAndProtectedAPI && (field.isPrivate() || field.isProtected()) || !reservedWords.contains(field.getName())) continue;
                this.addHit(field, "Field '" + field.getName() + "' is a reserved keyword in other languages!");
            }
        }
    }
}

