/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.27.5.4")
@CheckName(value="SVTB.27.5.4")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Do not use O or l/I as a prefix_ or _suffix")
@CheckDescription(value="Do not use capital o (O), lowercase L (l), or capital I (I) alone as prefix or suffix.\nDifferent fonts make zero (0) and capital o (O) look the same.\nDifferent fonts make one (1) look like lower case L (l) and/or capital i (I).\nThis rule applies to the names of everything: classes, variables, interfaces, modules, ports, parameters, etc.\nThis only applies to using the specific character case when used alone as the prefix or suffix.\n\nExamples:\nclass a;\n\tint l_a; // not allowed\n\tint O_b; // not allowed\n\tint c; // allowed\nendclass\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_27_5_4
extends AbstractSVTBSimpleIssues {
    public Check_SVTB_27_5_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(9);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return "0/O or l/I used as a prefix or suffix";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        return this.fOVMProject.getSVTBIssuesWithKind(9);
    }
}

