/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.27.5.5")
@CheckName(value="SVTB.27.5.5")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="m_ prefix is reserved for member variables")
@CheckDescription(value="If non-member variables use m_ then it loses its unique meaning.\nNon-member variables cannot use m_ prefix. Interfaces, tasks and functions cannot use m_ prefix.\n\nExamples:\ninterface m_int; // not allowed\n\tlogic [7:0] m_data; // not allowed\nendinterface\nclass a;\n\tint m_a; // allowed\n\tint m_b; // allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_5_5
extends OVMComplianceCheck {
    public Check_SVTB_27_5_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(namedElement -> {
            if (!namedElement.isPredefined() && !namedElement.isAnonymous()) {
                void field;
                void var3_2;
                RfField rfField;
                this.notifyCheckAlive();
                RfNamedElement rfNamedElement = namedElement;
                if (rfNamedElement instanceof RfField && (rfField = (RfField)rfNamedElement) == (RfField)var3_2 && field.isField() && !field.isFromEmbeddedCovergroupDef() && field.getEnclosingScope() instanceof RfClass) {
                    return true;
                }
                if (this.isNamedElementPreWaived(namedElement)) {
                    return true;
                }
                if (namedElement.getName().startsWith("m_")) {
                    this.addHit(namedElement, "'" + namedElement.getName() + "' is not a class member variable!");
                }
            }
            return true;
        });
    }

    public boolean isNamedElementPreWaived(RfNamedElement element) {
        if (element == null) {
            return true;
        }
        RfFileDef file = element.getFile();
        if (file == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this);
    }
}

