/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractReservedPhraseCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;

@CheckVersion(value="17.1.43")
@CheckID(value="SVTB.27.5.6")
@CheckName(value="SVTB.27.5.6")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.TYPEDEF})
@CheckTitle(value="_t suffix is reserved for typedefs")
@CheckDescription(value="If non-typedefs use _t then it loses its unique meaning.\nNon-typedefs variables cannot use _t suffix.\nTypedef struct, union and enum are not considered typedefs and should have their own suffix.\n\nExamples:\ninterface intf_t; // not allowed\n\tlogic [7:0] data_t; // not allowed\nendinterface\n\ntypedef int int_t; // allowed\n\nExamples for skipNestedTypedefsOfStructs='true':\ntypedef enum {a, b} c_t; // not allowed\ntypedef c_t d_t; // allowed")
public class Check_SVTB_27_5_6
extends AbstractReservedPhraseCheck {
    @CheckParameter(defaultValue="false", description="When parameter is set to true nested typedefs over struct, enum and union are considered typedef, not struct, union or enum.", name="skipNestedTypedefsOfStructs", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipNestedTypedefsOfStructs;

    public Check_SVTB_27_5_6(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected Map<ParserPath, Set<RfNamedElement>> getAllowedElements() {
        HashMap<ParserPath, Set<RfNamedElement>> result = new HashMap<ParserPath, Set<RfNamedElement>>();
        for (RfNamedElement elem : this.fOVMProject.getAllTypedefs()) {
            RfNamedElement associatedType;
            if (!(elem instanceof RfAssociatedType) || (associatedType = !this.pSkipNestedTypedefsOfStructs ? LintUtils.getAssociatedFinalType((RfAssociatedType)elem) : ((RfAssociatedType)elem).getAssociatedType()) instanceof RfStruct) continue;
            ParserPath parserPath = elem.getDeclaration().getParserPath();
            HashSet<RfNamedElement> localTypedefs = (HashSet<RfNamedElement>)result.get(parserPath);
            if (localTypedefs == null) {
                localTypedefs = new HashSet<RfNamedElement>();
                localTypedefs.add(elem);
                result.put(parserPath, localTypedefs);
                continue;
            }
            localTypedefs.add(elem);
        }
        return result;
    }

    @Override
    protected void setParameterValues() {
        this.allowedType = "typedef";
        this.reservedPhrase = "_t";
        this.isPrefix = false;
    }
}

