/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractReservedPhraseCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;

@CheckVersion(value="17.1.43")
@CheckID(value="SVTB.27.5.7")
@CheckName(value="SVTB.27.5.7")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.ENUM})
@CheckTitle(value="_e suffix is reserved for enums")
@CheckDescription(value="If non-enums use _e then it loses its unique meaning.\nNon-enum variables cannot use _e suffix.\n\nExamples:\ninterface intf_e; // not allowed\n\tlogic [7:0] data_e; // not allowed\nendinterface\n\ntypedef enum {red, green, blue} colors_e; // allowed\n")
public class Check_SVTB_27_5_7
extends AbstractReservedPhraseCheck {
    public Check_SVTB_27_5_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected Map<ParserPath, Set<RfNamedElement>> getAllowedElements() {
        HashMap<ParserPath, Set<RfNamedElement>> allEnums = new HashMap<ParserPath, Set<RfNamedElement>>();
        for (RfNamedElement elem : this.fOVMProject.getAllTypedefs()) {
            RfNamedElement associatedType;
            if (!(elem instanceof RfAssociatedType) || !((associatedType = LintUtils.getAssociatedFinalType((RfAssociatedType)elem)) instanceof RfStruct) || !((RfStruct)associatedType).isEnum()) continue;
            ParserPath parserPath = elem.getDeclaration().getParserPath();
            HashSet<RfNamedElement> localEnums = (HashSet<RfNamedElement>)allEnums.get(parserPath);
            if (localEnums == null) {
                localEnums = new HashSet<RfNamedElement>();
                localEnums.add(elem);
                allEnums.put(parserPath, localEnums);
                continue;
            }
            localEnums.add(elem);
        }
        return allEnums;
    }

    @Override
    protected void setParameterValues() {
        this.allowedType = "enum";
        this.reservedPhrase = "_e";
        this.isPrefix = false;
    }
}

