/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.ExplicitImportInfo;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="20.1.1")
@CheckID(value="SVTB.27.6.3")
@CheckName(value="SVTB.27.6.3")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.ENUM})
@CheckTitle(value="Unique enum item names")
@CheckDescription(value="An enum item name should be unique in its scope.\n\nExamples:\nclass A1;\n\ttypedef enum {a=2} Test1;\n\ttypedef enum {a=5, b=6} Test2;\n\n\tfunction f1(); // allowed\n\t\t$display(a); // not allowed\n\t\t$display(b); // allowed\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_6_3
extends OVMComplianceCheck {
    private Map<RfNamedElement, List<RfStruct>> visibleEnumsInScope = new HashMap<RfNamedElement, List<RfStruct>>();

    public Check_SVTB_27_6_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.visibleEnumsInScope.clear();
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<RfHid>(){
            private ParserPath parserPath;
            private RfNamedElement scope;

            public boolean visit(RfHid hidObject) {
                if (hidObject == null) {
                    return true;
                }
                IRfNamedElement element = hidObject.getElement();
                if (!(element instanceof RfField) || !((RfField)element).isEnumElement()) {
                    return true;
                }
                HidOccurrence occurence = hidObject.getOccurrence();
                if (occurence == null) {
                    return true;
                }
                if (Check_SVTB_27_6_3.this.pathIsPrewaived(this.parserPath)) {
                    return true;
                }
                Check_SVTB_27_6_3.this.notifyCheckAlive();
                List<Object> visibleEnums = new ArrayList();
                HidAccess parentAccess = hidObject.getParentAccess();
                if (parentAccess != null) {
                    IRfNamedElement type = parentAccess.getAssociatedType();
                    if (!(type instanceof RfNamedElement)) {
                        return true;
                    }
                    RfNamedElement container = (RfNamedElement)type;
                    List<RfStruct> enumTypesWithPrefix = container.getEnumTypesWithPrefix("", 2, 1);
                    if (enumTypesWithPrefix != null) {
                        visibleEnums.addAll(enumTypesWithPrefix);
                    }
                } else if (Check_SVTB_27_6_3.this.visibleEnumsInScope.containsKey(this.scope)) {
                    visibleEnums = Check_SVTB_27_6_3.this.visibleEnumsInScope.get(this.scope);
                } else {
                    visibleEnums = this.getVisibleEnums(this.scope);
                    Check_SVTB_27_6_3.this.visibleEnumsInScope.put(this.scope, visibleEnums);
                }
                if (visibleEnums == null || visibleEnums.isEmpty()) {
                    return true;
                }
                String elementName = element.getName();
                Map<String, List<RfStruct>> duplicateEnumMember = this.getDuplicateEnumMember(visibleEnums);
                this.addHitIfNeeded(duplicateEnumMember, elementName, occurence, element);
                return true;
            }

            public void setHolder(IHidHolder holder) {
                this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
            }

            private Map<String, List<RfStruct>> getDuplicateEnumMember(List<RfStruct> visibleEnums) {
                Collection<RfNamedElement> members = null;
                HashMap<String, List<RfStruct>> duplicateEnumMember = new HashMap<String, List<RfStruct>>();
                if (visibleEnums == null) {
                    return duplicateEnumMember;
                }
                for (RfStruct visibleEnum : visibleEnums) {
                    members = visibleEnum.getMembers();
                    if (members == null) continue;
                    for (RfNamedElement member : members) {
                        String memberName;
                        if (!(member instanceof RfField) || (memberName = member.getName()) == null) continue;
                        duplicateEnumMember.putIfAbsent(memberName, new ArrayList());
                        ((List)duplicateEnumMember.get(memberName)).add(visibleEnum);
                    }
                }
                return duplicateEnumMember;
            }

            private List<RfStruct> getVisibleEnums(RfNamedElement enumUsageScope) {
                HashSet<RfStruct> visibleEnums = new HashSet<RfStruct>();
                RfNamedElement scope = enumUsageScope;
                List<RfStruct> enumsInScope = null;
                while (scope != null) {
                    if (scope instanceof RfClass) {
                        RfClass classScope = (RfClass)scope;
                        while (classScope != null) {
                            enumsInScope = this.getVisibleEnumsIncludingImports(classScope);
                            if (enumsInScope != null) {
                                visibleEnums.addAll(enumsInScope);
                            }
                            classScope = classScope.getParent();
                        }
                    }
                    if ((enumsInScope = this.getVisibleEnumsIncludingImports(scope)) != null) {
                        visibleEnums.addAll(enumsInScope);
                    }
                    scope = scope.getEnclosingScope();
                }
                return new ArrayList<RfStruct>(visibleEnums);
            }

            private List<RfStruct> getVisibleEnumsIncludingImports(RfNamedElement enclosingScope) {
                HashSet<RfStruct> visibleEnums = new HashSet<RfStruct>();
                NullProtectedList<ImportInfo> importDeclarations = enclosingScope.getAllImportDeclarations();
                ArrayList<RfPackage> packagesFullyImported = new ArrayList<RfPackage>();
                List<RfStruct> enumsInPackage = enclosingScope.getEnumTypesWithPrefix("", 2, 1);
                if (enumsInPackage != null) {
                    visibleEnums.addAll(enumsInPackage);
                }
                if (importDeclarations != null) {
                    for (ImportInfo declaration : importDeclarations) {
                        if (declaration instanceof ExplicitImportInfo) {
                            IRfNamedElement namedElement;
                            IRfNamedElement element = ((ExplicitImportInfo)declaration).getElement();
                            if (!(element instanceof RfTypeAlias) || !((namedElement = ((RfTypeAlias)element).getResolvedType(true)) instanceof RfStruct)) continue;
                            visibleEnums.add((RfStruct)namedElement);
                            continue;
                        }
                        IRfPackageElement importedPackage = declaration.getPackage();
                        if (!(importedPackage instanceof RfPackage)) continue;
                        packagesFullyImported.add((RfPackage)importedPackage);
                    }
                }
                if (packagesFullyImported != null) {
                    for (RfPackage rfPackage : packagesFullyImported) {
                        enumsInPackage = rfPackage.getEnumTypesWithPrefix("", 2, 1);
                        if (enumsInPackage == null) continue;
                        visibleEnums.addAll(enumsInPackage);
                    }
                }
                return new ArrayList<RfStruct>(visibleEnums);
            }

            private void addHitIfNeeded(Map<String, List<RfStruct>> duplicateEnumMember, String elementName, HidOccurrence occurence, IRfNamedElement element) {
                if (duplicateEnumMember == null || duplicateEnumMember.isEmpty()) {
                    return;
                }
                if (!duplicateEnumMember.containsKey(elementName)) {
                    return;
                }
                List<RfStruct> enumElements = duplicateEnumMember.get(elementName);
                if (enumElements == null || enumElements.size() < 2) {
                    return;
                }
                String message = "Enum item '" + element.getName() + "' can be found in the following types: ";
                int i = 0;
                while (i < enumElements.size() - 1) {
                    RfStruct enumElem = enumElements.get(i);
                    message = String.valueOf(message) + this.getFullName(enumElem);
                    if (i == enumElements.size() - 2) break;
                    message = String.valueOf(message) + ", ";
                    ++i;
                }
                message = String.valueOf(message) + " and ";
                message = String.valueOf(message) + this.getFullName(enumElements.get(enumElements.size() - 1));
                message = String.valueOf(message) + "!";
                Check_SVTB_27_6_3.this.addHit(this.parserPath, occurence, message);
            }

            private String getFullName(RfStruct enumElem) {
                String scopePath = "";
                RfNamedElement scope = enumElem.getEnclosingScope();
                String name = "";
                String aliasName = "";
                int line = 0;
                ParserPath path = null;
                RfFileDef file = null;
                String printableScopePath = "";
                line = scope.getLine();
                file = scope.getFile();
                if (file == null) {
                    return "";
                }
                path = file.getParserPath();
                while (scope != null && !(scope instanceof RfLibrary)) {
                    name = scope.getName();
                    if (name.isEmpty()) break;
                    scopePath = String.valueOf(name) + "::" + scopePath;
                    scope = scope.getEnclosingScope();
                }
                aliasName = enumElem.getAliasName();
                if (aliasName == null) {
                    printableScopePath = scopePath.substring(0, scopePath.length() - 2);
                    if (line == 0 || path == null) {
                        return " a field of type enum in '" + printableScopePath + "'";
                    }
                    return " a field of type enum in '" + Check_SVTB_27_6_3.this.link(printableScopePath, path.path, line) + "'";
                }
                line = enumElem.getLine();
                file = enumElem.getFile();
                path = file.getParserPath();
                return Check_SVTB_27_6_3.this.link(String.valueOf(scopePath) + aliasName, path.path, line);
            }

            public Class<RfHid> getType() {
                return RfHid.class;
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }
        });
    }

    protected boolean pathIsPrewaived(ParserPath path) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }
}

