/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.27.7.1")
@CheckName(value="SVTB.27.7.1")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.MACRO})
@CheckTitle(value="Uppercase macros")
@CheckDescription(value="All macros (`defines) must include capital letters, numbers, and underscores only.\n\nExamples:\n`define simple_macro 1 // not allowed\n`define number_macro_2 2 // not allowed\n`define MY_MACRO 3 // allowed\n`define MY_VALUE_123 123 // allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_7_1
extends OVMComplianceCheck {
    public Check_SVTB_27_7_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        block0: for (VlogMacroInfo macro : this.fOVMProject.getAllMacros()) {
            List<VlogMacroInfo> layers;
            String macroName;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(macro.getFile()) || (macroName = macro.getName()).matches("^[A-Z_0-9]*$") || (layers = macro.getMacroZoneLayers()) == null) continue;
            for (VlogMacroInfo layer : layers) {
                if (layer.isUndef() || !layer.isReplacementMacro()) continue;
                this.addHit(layer.getFileInstance().getParserPath(), layer.getLine(), "'`" + macroName + "' macro should be capitalized!", null);
                continue block0;
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

