/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_27_8_1;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.27.8.1")
@CheckName(value="SVTB.27.8.1")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.CONSTANT, RuleLabel.PARAMETER})
@CheckTitle(value="Uppercase constants")
@CheckDescription(value="All constants must be capitalized:\nconst int MY_CONST = 5;\nparameter MY_PARAM = 3;\nlocalparam MY_LCL_PARAM = 7;\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_27_8_1.class)
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_27_8_1
extends AbstractSVTBSimpleIssues {
    @CheckParameter(defaultValue="constant, value_parameter, type_parameter, specparam", description="Comma separated list of: constant, value_parameter, type_parameter, specparam.", name="elementKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pCheckedElementKinds;

    public Check_SVTB_27_8_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(4);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        if (issue != null && issue.getInfo() != null) {
            String constantKind = "Constant variable";
            switch (issue.getCarry()) {
                case 3: {
                    constantKind = "Value parameter";
                    break;
                }
                case 5: {
                    constantKind = "Type parameter";
                    break;
                }
                case 4: {
                    constantKind = "Specparam";
                }
            }
            return String.valueOf(constantKind) + " '" + issue.getInfo() + "' should be capitalized!";
        }
        return "Constant should be capitalized!";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        int length = 0;
        int[] carrys = new int[4];
        if (this.pCheckedElementKinds.contains("constant")) {
            carrys[length++] = 1;
        }
        if (this.pCheckedElementKinds.contains("value_parameter")) {
            carrys[length++] = 3;
        }
        if (this.pCheckedElementKinds.contains("type_parameter")) {
            carrys[length++] = 5;
        }
        if (this.pCheckedElementKinds.contains("specparam")) {
            carrys[length++] = 4;
        }
        return this.fOVMProject.getSVTBIssuesWithKind(4, false, carrys);
    }

    @Override
    public String getAdditionalInfoForDisplayString(OVMComplianceCheckHit hit) {
        VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
        if (additionalInfo == null) {
            return null;
        }
        Object element = additionalInfo.getElement();
        if (!(element instanceof SVTBIssues)) {
            return null;
        }
        return "constant '" + ((SVTBIssues)element).getInfo() + "'";
    }
}

