/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_27_9_1;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.DataDeclarationChecker;
import ro.amiq.vlogdt.linter.svtb.IDataDeclarationCheck;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.27.9.1")
@CheckName(value="SVTB.27.9.1")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.MODPORT, RuleLabel.VIRTUAL_INTERFACE})
@CheckTitle(value="Name all modport virtual interfaces with the _mp suffix")
@CheckDescription(value="Name all modport virtual interfaces with the _mp suffix.\nDo not confuse this rule with modport definition naming conventions.\n\nExample:\nvirtual my_bus_if.bfm_mp my_bus_mp; // Virtual interface to the bfm modport of my bus interface\n\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_27_9_1.class)
public class Check_SVTB_27_9_1
extends OVMComplianceCheck
implements IDataDeclarationCheck {
    public Check_SVTB_27_9_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        DataDeclarationChecker checker = new DataDeclarationChecker(this.fOVMProject, this);
        checker.visit();
    }

    @Override
    public void notifyPerformCheck(RfField aField) {
        IRfNamedElement assocType = aField.getAssociatedType();
        if (assocType != null && assocType instanceof RfModport && !aField.getName().endsWith("_mp")) {
            this.addHit(aField, "Virtual modport '" + aField.getName() + "' of '" + ((RfModport)assocType).getFullName() + "' does not end with _mp!", new VerissimoAutofixAdditionalInfo(aField));
        }
    }

    @Override
    public void notifyCheckIsAlive() {
        this.notifyCheckAlive();
    }

    @Override
    public String getAdditionalInfoForDisplayString(OVMComplianceCheckHit hit) {
        VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
        if (additionalInfo == null) {
            return null;
        }
        Object element = additionalInfo.getElement();
        if (!(element instanceof RfNamedElement)) {
            return null;
        }
        return "virtual modport '" + ((RfNamedElement)element).getName() + "'";
    }
}

