/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractInstanceNamingCheck;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1.6")
@CheckID(value="SVTB.27.9.2")
@CheckName(value="SVTB.27.9.2")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.DESIGN_INSTANTIATION, RuleLabel.INTERFACE})
@CheckTitle(value="Interface instances naming pattern")
@CheckDescription(value="All interface instances must match the namePattern pattern.\n\nImplementation Notes:\nInterface instances inside modules are checked.\n\nExamples for namePattern='intf\\d':\ninterface my_intf;\nendinterface\n\nmodule m;\n\tmy_intf a(); // not allowed\n\tmy_intf intf1(); // allowed\nendmodule\n\nExamples for namePattern='$type_name_inst':\n\nmodule m;\n\tmy_intf my_inst(); // not allowed\n\tmy_intf my_intf_inst(); // allowed\nendmodule\n")
public class Check_SVTB_27_9_2
extends AbstractInstanceNamingCheck {
    public Check_SVTB_27_9_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected boolean hasRightType(RfNamedElement fieldType) {
        return fieldType instanceof RfInterface;
    }

    @Override
    protected void addLocalHit(RfNamedElement eachMember, String name, String memberName) {
        this.addHit(eachMember, "Illegal name for interface instance '" + name + "." + memberName + "'!");
    }
}

