/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.ClassMembersIterator;
import ro.amiq.vlogdt.linter.svtb.ModuleMembersIterator;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1.6")
@CheckID(value="SVTB.27.9.3")
@CheckName(value="SVTB.27.9.3")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.VIRTUAL_INTERFACE})
@CheckTitle(value="Virtual interface members naming pattern")
@CheckDescription(value="All virtual interface members must match the namePattern pattern.\n\nImplementation Notes:\nVirtual interface members inside modules and classes are checked.\n\nExamples for namePattern='intf\\d':\ninterface my_intf;\nendinterface\n\nclass a;\n\tprotected virtual my_intf a; // not allowed\n\tprotected virtual my_intf intf1; // allowed\nendclass\n")
public class Check_SVTB_27_9_3
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="The member name pattern.", name="namePattern", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.REGEX)
    private Pattern pNamePatternValue;
    @CheckParameter(defaultValue="", description="Comma separated list of legal name exceptions.", name="nameExceptions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pNameExceptionsValue;
    @CheckParameter(defaultValue="false", description="Allow name exceptions only if there is a single virtual interface in the component", name="allowExceptionsForSingleMember", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowExceptionsForSingleMember;

    public Check_SVTB_27_9_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<String> moduleMembersIteratorKeys = new HashSet<String>();
        moduleMembersIteratorKeys.add("field");
        for (RfNamedElement eachModule : this.fOVMProject.getAllModules()) {
            this.notifyCheckAlive();
            if (eachModule == null || !(eachModule instanceof RfModule)) continue;
            ModuleMembersIterator moduleMembersIterator = new ModuleMembersIterator((RfModule)eachModule, moduleMembersIteratorKeys, true);
            this.checkMembers(eachModule, moduleMembersIterator, this.pNamePatternValue, this.pNameExceptionsValue);
        }
        HashSet<String> classMembersIteratorKeys = new HashSet<String>();
        classMembersIteratorKeys.add("field");
        for (RfNamedElement eachClass : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            if (eachClass == null || !(eachClass instanceof RfClass)) continue;
            ClassMembersIterator classMembersIterator = new ClassMembersIterator((RfClass)eachClass, classMembersIteratorKeys, true);
            this.checkMembers(eachClass, classMembersIterator, this.pNamePatternValue, this.pNameExceptionsValue);
        }
    }

    private void checkMembers(RfNamedElement aMembersContainer, Iterator<RfNamedElement> aMembersIterator, Pattern aNamePattern, HashSet<String> aNameExceptions) {
        if (aMembersContainer == null || aMembersIterator == null || aNamePattern == null || aNameExceptions == null) {
            return;
        }
        NullProtectedList<RfNamedElement> members = new NullProtectedList<RfNamedElement>();
        while (aMembersIterator.hasNext()) {
            String memberName;
            RfField eachField;
            RfNamedElement fieldType;
            RfNamedElement eachMember = aMembersIterator.next();
            if (eachMember == null || !(eachMember instanceof RfField) || (fieldType = LintUtils.getAssociatedFinalType(eachField = (RfField)eachMember)) == null || !(fieldType instanceof RfInterface) || (memberName = eachMember.getName()) == null) continue;
            members.add(eachMember);
        }
        for (RfNamedElement eachMember : members) {
            Matcher m;
            boolean multipleMembers;
            String memberName = eachMember.getName();
            boolean isException = aNameExceptions.contains(memberName);
            boolean bl = multipleMembers = members.size() > 1;
            if ((this.pAllowExceptionsForSingleMember || isException) && (!this.pAllowExceptionsForSingleMember || !multipleMembers && isException) || aNamePattern.pattern().isEmpty() || (m = aNamePattern.matcher(memberName)).matches()) continue;
            this.addHit(eachMember, "Illegal name for virtual interface member '" + aMembersContainer.getName() + "." + memberName + "'!");
        }
    }
}

