/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfCovercross;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="16.1.16")
@CheckID(value="SVTB.27.9.4")
@CheckName(value="SVTB.27.9.4")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.COVERGROUP})
@CheckTitle(value="Covergroup member naming pattern")
@CheckDescription(value="Covergroup <memberKind> must match the <namePattern>.\n\nExamples for memberKind='coverpoint' and namePattern='cp_.':\n\ncovergroup cov1 (ref int x, ref int y, input int c);\n\tcoverpoint cp_10; // allowed\n\tcp_11: coverpoint c1; // not allowed\nendgroup\n\nCheck supports pre-waiving.")
public class Check_SVTB_27_9_4
extends OVMComplianceCheck {
    private static final String COVERPOINT_VALUE = "coverpoint";
    private static final String COVERCROSS_VALUE = "covercross";
    @CheckParameter(defaultValue="", description="One of coverpoint or covercross.", name="memberKind", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.STRING)
    private String pMemberKindValue;
    @CheckParameter(defaultValue="", description="The member name pattern.", name="namePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pNamePatternValue;

    public Check_SVTB_27_9_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (!this.pMemberKindValue.equals(COVERPOINT_VALUE) && !this.pMemberKindValue.equals(COVERCROSS_VALUE)) {
            this.addHit(null, "Unrecognized element kind '" + this.pMemberKindValue + "'!");
            return;
        }
        for (RfNamedElement coverGroup : this.fOVMProject.getAllCovergroups()) {
            List<RfCoverpoint> candidates;
            if (this.checkPreWaivers(coverGroup.getFile()) || (candidates = coverGroup.getLocalMembers(RfCoverpoint.class)) == null || candidates.isEmpty()) continue;
            this.notifyCheckAlive();
            for (RfCoverpoint candidate : candidates) {
                Matcher matcher;
                if (candidate.isAnonymous() || this.pMemberKindValue.equals(COVERCROSS_VALUE) && !(candidate instanceof RfCovercross) || this.pMemberKindValue.equals(COVERPOINT_VALUE) && candidate instanceof RfCovercross || (matcher = this.pNamePatternValue.matcher(candidate.getName())).matches()) continue;
                String memberKind = LintUtils.getElementKind(candidate);
                memberKind = String.valueOf(Character.toUpperCase(memberKind.charAt(0))) + memberKind.substring(1);
                this.addHit(candidate, String.valueOf(memberKind) + " '" + candidate.getName() + "' does not match the pattern '" + this.pNamePatternValue.pattern() + "'!");
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

