/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.28.1")
@CheckName(value="SVTB.28.1")
@CheckLabel(labels={RuleLabel.GLOBAL, RuleLabel.PACKAGE})
@CheckTitle(value="Nothing should be declared in the global namespace")
@CheckDescription(value="All classes, methods, types, variables must be declared within a package. This ensures that there are no namespace collisions.\n\nExamples:\n\npackage my_pkg;\n\tfunction void foo(); // allowed\n\tendfunction\nendpackage\n\nfunction void bar() // not allowed;\nendfunction\n\nCheck supports pre-waiving.")
public class Check_SVTB_28_1
extends OVMComplianceCheck {
    public Check_SVTB_28_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        boolean anyFailure = false;
        Collection<RfLibrary> libraries = rfProject.getAllLibraries();
        if (libraries != null) {
            for (RfLibrary library : libraries) {
                anyFailure |= this.checkNamedElement(library.getLocalFields(), "variable");
                anyFailure |= this.checkNamedElement(library.getLocalFunctions(), "function");
                anyFailure |= this.checkNamedElement(library.getLocalTasks(), "task");
                anyFailure |= this.checkNamedElement(library.getLocalMembers(RfClass.class), "class");
                anyFailure |= this.checkNamedElement(library.getLocalMembers(RfCovergroup.class), "covergroup");
                anyFailure |= this.checkNamedElement(library.getTypeAliases(), "type");
                anyFailure |= this.checkNamedElement(library.getParametersWithPrefix("", 128, 2, 1), "parameter");
                anyFailure |= this.checkNamedElement(library.getParametersWithPrefix("", 256, 2, 1), "type parameter");
            }
        }
        if (!anyFailure) {
            this.addPassedHit(null, "All classes, methods, types and variables are declared inside a package.");
        }
    }

    private boolean checkNamedElement(Collection<? extends RfNamedElement> outsideElements, String name) {
        boolean anyFailure = false;
        if (outsideElements == null || outsideElements.isEmpty()) {
            return anyFailure;
        }
        for (RfNamedElement rfNamedElement : outsideElements) {
            if (this.checkPreWaivers(rfNamedElement.getFile()) || this.fOVMProject.isOVMElement(rfNamedElement)) continue;
            this.notifyCheckAlive();
            String elemName = name;
            if (rfNamedElement instanceof RfField && ((RfField)rfNamedElement).isNet()) {
                elemName = "net";
            }
            this.addHit(rfNamedElement, "'" + rfNamedElement.getName() + "' " + elemName + " is declared outside a package");
            anyFailure = true;
        }
        return anyFailure;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

