/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import java.util.HashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfAbstractBlock;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModportPort;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfStruct;

@CheckVersion(value="20.1.2")
@CheckID(value="SVTB.28.2")
@CheckName(value="SVTB.28.2")
@CheckLabel(labels={RuleLabel.GLOBAL, RuleLabel.FIELD})
@CheckTitle(value="Variables should be declared only in specified scopes")
@CheckDescription(value="Variables can only be declared in the scopes specified by <allowedScopes>.\n\nExamples:\nclass my_class;\n\tint a; // allowed\nendclass\n\nfunction void foo();\n\tint b; // allowed\nendfunction\n\nint x; // not allowed, global scope\n\nCheck supports pre-waiving.")
public class Check_SVTB_28_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="checker, class, constructor, function, interface, module, package, program, task", description="Comma separated list of scopes where variables can be declared: checker, class, constructor, function, interface, library, module, package, program and task.", name="allowedScopes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAllowedScopes;
    private static HashSet<String> allScopes = new HashSet();
    private static HashSet<Class<? extends RfNamedElement>> allScopesClasses;
    private static final String CHECKER = "checker";
    private static final String CLASS = "class";
    private static final String CONSTRUCTOR = "constructor";
    private static final String FUNCTION = "function";
    private static final String INTERFACE = "interface";
    private static final String LIBRARY = "library";
    private static final String MODULE = "module";
    private static final String PACKAGE = "package";
    private static final String PROGRAM = "program";
    private static final String TASK = "task";

    static {
        allScopes.add(CHECKER);
        allScopes.add(CLASS);
        allScopes.add(CONSTRUCTOR);
        allScopes.add(FUNCTION);
        allScopes.add(INTERFACE);
        allScopes.add(LIBRARY);
        allScopes.add(MODULE);
        allScopes.add(PACKAGE);
        allScopes.add(PROGRAM);
        allScopes.add(TASK);
        allScopesClasses = new HashSet();
        allScopesClasses.add(RfChecker.class);
        allScopesClasses.add(RfClass.class);
        allScopesClasses.add(RfFunction.class);
        allScopesClasses.add(RfInterface.class);
        allScopesClasses.add(RfLibrary.class);
        allScopesClasses.add(RfModule.class);
        allScopesClasses.add(RfPackage.class);
        allScopesClasses.add(RfProgram.class);
    }

    public Check_SVTB_28_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        for (String allowedScope : this.pAllowedScopes) {
            if (allScopes.contains(allowedScope)) continue;
            this.signalParamError("'" + allowedScope + "' is not allowed as parameter!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                Collection<RfNamedElement> members;
                if (Check_SVTB_28_2.this.checkPreWaivers(namedElement.getFile())) {
                    return true;
                }
                if (this.shouldSkip(namedElement)) {
                    return true;
                }
                Check_SVTB_28_2.this.notifyCheckAlive();
                RfNamedElement enclosingScope = null;
                RfNamedElement scopeToShow = null;
                if (namedElement instanceof RfAbstractBlock) {
                    enclosingScope = namedElement.getEnclosingScope();
                    while (enclosingScope != null) {
                        if (this.shouldSkip(enclosingScope)) {
                            return true;
                        }
                        if (scopeToShow == null && this.isSelectable(enclosingScope)) {
                            scopeToShow = enclosingScope;
                            break;
                        }
                        enclosingScope = enclosingScope.getEnclosingScope();
                    }
                }
                if ((members = namedElement.getMembers()) == null || members.isEmpty()) {
                    return true;
                }
                for (RfNamedElement member : members) {
                    String scopeName;
                    RfField field;
                    if (!(member instanceof RfField) || (field = (RfField)member).isTypeParameter() || field.isParameter() || field.isArgument() || field.isCoverpoint() || field.isFromEmbeddedCovergroupDef() || field instanceof RfModportPort) continue;
                    if (scopeToShow == null) {
                        scopeToShow = namedElement;
                    }
                    if ((scopeName = LintUtils.getScopeName(scopeToShow)) != null && !scopeName.isEmpty()) {
                        Check_SVTB_28_2.this.addHit(member, "Variable '" + LintUtils.getNamedElementFullName(member) + "' should not be declared in " + LintUtils.getScopeName(scopeToShow) + "!");
                        continue;
                    }
                    Check_SVTB_28_2.this.addHit(member, "Variable '" + LintUtils.getNamedElementFullName(member) + "' is not declared in an allowed scope!");
                }
                return true;
            }

            private boolean isSelectable(RfNamedElement enclosingScope) {
                if (enclosingScope == null) {
                    return false;
                }
                return allScopesClasses.contains(enclosingScope.getClass());
            }

            private boolean shouldSkip(RfNamedElement namedElement) {
                if (namedElement instanceof RfField) {
                    return true;
                }
                if (namedElement instanceof RfStruct) {
                    return true;
                }
                if (Check_SVTB_28_2.this.pAllowedScopes.contains(Check_SVTB_28_2.CHECKER) && namedElement instanceof RfChecker) {
                    return true;
                }
                if (Check_SVTB_28_2.this.pAllowedScopes.contains(Check_SVTB_28_2.CLASS) && namedElement instanceof RfClass) {
                    return true;
                }
                if (Check_SVTB_28_2.this.pAllowedScopes.contains(Check_SVTB_28_2.INTERFACE) && namedElement instanceof RfInterface) {
                    return true;
                }
                if (Check_SVTB_28_2.this.pAllowedScopes.contains(Check_SVTB_28_2.LIBRARY) && namedElement instanceof RfLibrary) {
                    return true;
                }
                if (Check_SVTB_28_2.this.pAllowedScopes.contains(Check_SVTB_28_2.MODULE) && namedElement instanceof RfModule) {
                    return true;
                }
                if (Check_SVTB_28_2.this.pAllowedScopes.contains(Check_SVTB_28_2.PACKAGE) && namedElement instanceof RfPackage) {
                    return true;
                }
                if (Check_SVTB_28_2.this.pAllowedScopes.contains(Check_SVTB_28_2.PROGRAM) && namedElement instanceof RfProgram) {
                    return true;
                }
                if (namedElement instanceof RfFunction) {
                    RfFunction function = (RfFunction)namedElement;
                    if (Check_SVTB_28_2.this.pAllowedScopes.contains(Check_SVTB_28_2.CONSTRUCTOR) && function.isConstructor()) {
                        return true;
                    }
                    if (Check_SVTB_28_2.this.pAllowedScopes.contains(Check_SVTB_28_2.FUNCTION) && function.isFunction()) {
                        return true;
                    }
                    if (Check_SVTB_28_2.this.pAllowedScopes.contains(Check_SVTB_28_2.TASK) && function.isTask()) {
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

