/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.text.MessageFormat;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractCheckUndocumentedApiUsages;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="20.1.42")
@CheckID(value="SVTB.29.10")
@CheckName(value="SVTB.29.10")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.FILE})
@CheckTitle(value="Banned API declared in files")
@CheckDescription(value="Do not use undocumented API that is declared in files matching <filePatterns>.\n\nExamples for bannedMethods = 'f1_example' and checkMethods='B_example2.g_example2':\nfunction f1_example();\nendfunction\n\nfunction f2_example();\nendfunction\n\nclass A_example2;\n\tfunction g_example2();\n\t\tf1_example(); // allowed\n\t\tf2_example(); // allowed\n\tendfunction\nendclass\n\nclass B_example2;\n\tfunction g_example2();\n\t\tf1_example(); // not allowed\n\t\tf2_example(); // allowed\n\tendfunction\nendclass\n")
public class Check_SVTB_29_10
extends AbstractCheckUndocumentedApiUsages {
    private static final String SHOULD_NOT_BE_USED = "{0} ''{1}'' should not be used!";
    @CheckParameter(defaultValue="", description="Comma separated list of file patterns.", name="filePatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    protected Set<Pattern> pFilePatterns;
    private static final String BANNED_API_FOUND = "Banned API found!";

    public Check_SVTB_29_10(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected String getMessage(IRfNamedElement element) {
        if (!(element instanceof RfNamedElement)) {
            return BANNED_API_FOUND;
        }
        return MessageFormat.format(SHOULD_NOT_BE_USED, DVTStringUtil.capitalizeFirstLetter((String)LintUtils.getElementKind((RfNamedElement)element)), LintUtils.getNamedElementFullName((RfNamedElement)element));
    }

    @Override
    protected boolean isBannedCategory(RfNamedElement element) {
        RfDefElement declaration = element.getDeclaration();
        if (declaration == null) {
            return false;
        }
        ParserPath parserPath = declaration.getParserPath();
        if (parserPath == null) {
            return false;
        }
        for (Pattern pattern : this.pFilePatterns) {
            if (!pattern.matcher(parserPath.path).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isAllowedMacro(String macroName) {
        return false;
    }
}

