/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractMethodCallCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1.6")
@CheckID(value="SVTB.29.1.0")
@CheckName(value="SVTB.29.1.0")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.METHOD})
@CheckTitle(value="Banned method calls")
@CheckDescription(value="Calls to bannedMethods are forbidden.\n\nImplementation Notes:\n Do not use typedef names in method full names, as typedefs are solved before checking.\n\nExamples for bannedMethods = '$display':\nmodule my_module;\n\tinitial begin\n\t\t$display(\"Display call!\"); // not allowed\n\tend\nendmodule\n\nCheck supports pre-waiving.")
public class Check_SVTB_29_1_0
extends AbstractMethodCallCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of banned methods full names.\nFor example $stop, $display, std::randomize,\npkg_1::task_2, pkg_1::class_2.class_3.function_4, interface_1.function_2, module_1.task_2, program_1.function_2,\n[fixed_size_array].min, [dynamic_array].min, [associative_array].min, [queue].min,\n[enum].num, [scalar].string.len.", name="bannedMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pBannedMethodsValue;
    @CheckParameter(defaultValue="", description="Comma separated list of banned methods full name patterns.", name="bannedMethodsPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    protected HashSet<Pattern> pBannedMethodsPatternsValue;
    @CheckParameter(defaultValue="", description="Comma separated list of base class patterns that will be skipped.", name="skipBaseClassPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    protected HashSet<Pattern> pSkipBaseClassPatterns;
    @CheckParameter(defaultValue="", description="Comma separated list of class patterns that will be skipped.", name="skipClassPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    protected HashSet<Pattern> pSkipClassPatterns;
    @CheckParameter(defaultValue="", description="Comma separated list of base class patterns that will be checked.", name="checkBaseClassPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    protected HashSet<Pattern> pCheckBaseClassPatterns;
    @CheckParameter(defaultValue="", description="Comma separated list of macro name patterns that will be skipped.", name="skipMacroNamePatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    protected HashSet<Pattern> pSkipMacroNamePatterns;
    @CheckParameter(defaultValue="", description="Comma separated list of scopes where the banned method calls are not allowed: always, initial, final, constructor, function and task.\nIf empty, method calls in any scope will be checked.", name="bannedScopes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pBannedScopes;
    private boolean skipClassChecking;
    private static HashSet<String> allScopes = new HashSet();
    private static final String CONSTRUCTOR = "constructor";
    private static final String FUNCTION = "function";
    private static final String TASK = "task";
    private static final String ALWAYS = "always";
    private static final String INITIAL = "initial";
    private static final String FINAL = "final";

    static {
        allScopes.add(ALWAYS);
        allScopes.add(INITIAL);
        allScopes.add(FINAL);
        allScopes.add(CONSTRUCTOR);
        allScopes.add(FUNCTION);
        allScopes.add(TASK);
    }

    public Check_SVTB_29_1_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        for (String bannedScope : this.pBannedScopes) {
            if (allScopes.contains(bannedScope)) continue;
            this.signalParamError("'Invalid banned scope: '" + bannedScope + "'!", true);
        }
    }

    private boolean checkClass(RfClass clazz) {
        if (clazz == null) {
            return false;
        }
        String fullName = clazz.getFullName();
        if (fullName == null) {
            return false;
        }
        for (Pattern pattern : this.pSkipClassPatterns) {
            if (!pattern.matcher(fullName).matches()) continue;
            return true;
        }
        boolean checkClass = this.pCheckBaseClassPatterns.isEmpty();
        RfClass parentClass = clazz;
        while (parentClass != null) {
            fullName = parentClass.getFullName();
            if (fullName == null) {
                return false;
            }
            for (Pattern pattern : this.pCheckBaseClassPatterns) {
                if (!pattern.matcher(fullName).matches()) continue;
                checkClass = true;
            }
            for (Pattern pattern : this.pSkipBaseClassPatterns) {
                if (!pattern.matcher(fullName).matches()) continue;
                return true;
            }
            parentClass = parentClass.getParent();
        }
        return !checkClass;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isBannedScope(IRfScopeElement scopeElement) {
        void var3_2;
        RfActionBlock rfActionBlock;
        IRfScopeElement iRfScopeElement = scopeElement;
        if (iRfScopeElement instanceof RfActionBlock && (rfActionBlock = (RfActionBlock)iRfScopeElement) == (RfActionBlock)var3_2) {
            void actionBlock;
            if (this.pBannedScopes.contains(INITIAL) && actionBlock.isInitial()) {
                return true;
            }
            if (this.pBannedScopes.contains(FINAL) && actionBlock.isFinal()) {
                return true;
            }
            if (this.pBannedScopes.contains(ALWAYS) && actionBlock.isAlways()) {
                return true;
            }
        }
        if (( instanceOfPatternExpressionValue = scopeElement) instanceof RfFunction var4_5) {
            void function;
            if (this.pBannedScopes.contains(CONSTRUCTOR) && function.isConstructor()) {
                return true;
            }
            if (this.pBannedScopes.contains(FUNCTION) && function.isFunction()) {
                return true;
            }
            if (this.pBannedScopes.contains(TASK) && function.isTask()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void performCheckImpl() {
        this.skipClassChecking = this.pSkipBaseClassPatterns.isEmpty() && this.pSkipClassPatterns.isEmpty() && this.pCheckBaseClassPatterns.isEmpty();
        this.skipScopeChecking = this.skipClassChecking && this.pBannedScopes.isEmpty();
        this.performCheckBase();
    }

    @Override
    public void checkMethodCall(ParserPath aParserPath, RfHid aHid, RfFunction aCalledFunction, RfNamedElement scope) {
        if (aCalledFunction == null) {
            return;
        }
        if (this.skipScope(scope)) {
            return;
        }
        IReparseInfo reparse = aHid.getReparseInfo();
        if (!this.pSkipMacroNamePatterns.isEmpty() && reparse != null && this.isMaskedByMacro(reparse)) {
            return;
        }
        String calledFunctionFullName = LintUtils.getNamedElementFullName(aCalledFunction);
        if (this.pBannedMethodsValue.contains(calledFunctionFullName) && (this.skipClassChecking || scope == null || !this.checkClass(scope.getEnclosingScope(RfClass.class)))) {
            this.addSpecialHit(aParserPath, aHid, "Banned method call '" + calledFunctionFullName + "()'!");
            return;
        }
        if (this.pBannedMethodsPatternsValue != null && !this.pBannedMethodsPatternsValue.isEmpty()) {
            for (Pattern pattern : this.pBannedMethodsPatternsValue) {
                if (!pattern.matcher(calledFunctionFullName).matches() || !this.skipClassChecking && scope != null && this.checkClass(scope.getEnclosingScope(RfClass.class))) continue;
                this.addSpecialHit(aParserPath, aHid, "Banned method call '" + calledFunctionFullName + "()'!");
                return;
            }
        }
    }

    @Override
    public void checkSystemCall(SVTBIssues issue, ParserPath filename, String systemId, IRfScopeElement scope) {
        if (issue == null) {
            return;
        }
        if (this.skipScope(scope)) {
            return;
        }
        ReparseInfo reparse = issue.getReparseInfo();
        if (!this.pSkipMacroNamePatterns.isEmpty() && reparse != null && this.isMaskedByMacro(reparse)) {
            return;
        }
        if (this.pBannedMethodsValue.contains(systemId) && (this.skipClassChecking || scope == null || !this.checkClass((RfClass)scope.getEnclosingScope(RfClass.class)))) {
            this.addHit(filename, issue.getLine(), "Banned method call '" + systemId + "()'!", issue.getReparseInfo());
            return;
        }
        if (this.pBannedMethodsPatternsValue != null && !this.pBannedMethodsPatternsValue.isEmpty()) {
            for (Pattern pattern : this.pBannedMethodsPatternsValue) {
                if (!pattern.matcher(systemId).matches() || !this.skipClassChecking && scope != null && this.checkClass((RfClass)scope.getEnclosingScope(RfClass.class))) continue;
                this.addHit(filename, issue.getLine(), "Banned method call '" + systemId + "()'!", issue.getReparseInfo());
                return;
            }
        }
    }

    public OVMComplianceHit addSpecialHit(ParserPath parserPath, RfHid hid, String message) {
        HidOccurrence hidOccurrence = hid.getOccurrence();
        return this.addHit(parserPath, hidOccurrence.getLine(), message, (ReparseInfo)hidOccurrence.getReparseInfo(), false);
    }

    public boolean isMaskedByMacro(IReparseInfo reparse) {
        if (!(reparse instanceof ReparseInfo)) {
            return false;
        }
        ReparseInfo reparseInfo = (ReparseInfo)reparse;
        ReparseInfo.ReparseElement[] reparseStack = reparseInfo.getReparseStack();
        if (reparseStack.length != 0) {
            ReparseInfo.ReparseElement[] reparseElementArray = reparseStack;
            int n = reparseStack.length;
            int n2 = 0;
            while (n2 < n) {
                ReparseInfo.ReparseElement reparseElem = reparseElementArray[n2];
                String macroName = reparseElem.getReparseMacroName();
                for (Pattern pattern : this.pSkipMacroNamePatterns) {
                    if (!pattern.matcher(macroName).matches()) continue;
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean skipScope(IRfScopeElement scope) {
        if (this.pBannedScopes.isEmpty()) {
            return false;
        }
        IRfScopeElement enclosingScope = scope;
        while (enclosingScope != null) {
            if (this.isBannedScope(enclosingScope)) {
                return false;
            }
            enclosingScope = enclosingScope.getEnclosingScope();
        }
        return true;
    }
}

