/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.utils.Utils;

@CheckVersion(value="20.1.37")
@CheckID(value="SVTB.29.1.10")
@CheckName(value="SVTB.29.1.10")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.METHOD})
@CheckTitle(value="Banned method calls from specified methods.")
@CheckDescription(value="Calls to bannedMethods either directly or indirectly made from checkMethods or overrides of checkMethods if checkMethodOverrides is true, are forbidden.")
@CheckReapplyDisable
public class Check_SVTB_29_1_10
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of banned methods full names. For example $stop, $display, std::randomize,\npkg_1::task_2, pkg_1::class_2.class_3.function_4, interface_1.function_2, module_1.task_2, program_1.function_2,\n[fixed_size_array].min, [dynamic_array].min, [associative_array].min, [queue].min,\n[enum].num, [scalar].string.len.", name="bannedMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pBannedMethods;
    @CheckParameter(defaultValue="", description="Comma separated list of methods full names to be checked for banned methods.", name="checkMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pCheckMethods;
    @CheckParameter(defaultValue="false", description="If true, method overrides listed by the 'checkMethods' parameter are also checked.", name="checkMethodOverrides", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckMethodOverrides;

    public Check_SVTB_29_1_10(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfFunction[] allFunctions = this.fOVMProject.getRfProject().getAllFunctionsAndTasks();
        if (allFunctions == null || allFunctions.length == 0) {
            return;
        }
        RfFunction[] rfFunctionArray = allFunctions;
        int n = allFunctions.length;
        int n2 = 0;
        while (n2 < n) {
            RfFunction function = rfFunctionArray[n2];
            String functionFullName = LintUtils.getNamedElementFullName(function);
            if (this.pCheckMethods.contains(functionFullName)) {
                Set<RfClass> children;
                HashSet<RfFunction> visitedFunctions = new HashSet<RfFunction>();
                ArrayList<RfFunction> functionCallTree = new ArrayList<RfFunction>();
                visitedFunctions.add(function);
                functionCallTree.add(function);
                RfClass functionClass = function.getEnclosingScope(RfClass.class);
                function.visitHidObject(this.fOVMProject.getRfProject(), new FunctionVisitor(visitedFunctions, functionCallTree, functionClass, "", 0));
                if (this.pCheckMethodOverrides && function.isVirtual() && (children = functionClass.getChildren()) != null && !children.isEmpty()) {
                    for (RfClass child : children) {
                        this.recursiveChildVisiting(child, function);
                    }
                }
            }
            ++n2;
        }
    }

    private void recursiveChildVisiting(RfClass childClass, RfFunction localFunction) {
        this.notifyCheckAlive();
        Collection<RfNamedElement> members = childClass.getMembers();
        for (RfNamedElement member : members) {
            RfFunction tempFunction;
            if (!(member instanceof RfFunction) || !(tempFunction = (RfFunction)member).getName().equals(localFunction.getName())) continue;
            localFunction = tempFunction;
            break;
        }
        HashSet<RfFunction> visitedFunctions = new HashSet<RfFunction>();
        ArrayList<RfFunction> functionCallTree = new ArrayList<RfFunction>();
        visitedFunctions.add(localFunction);
        functionCallTree.add(localFunction);
        localFunction.visitHidObject(this.fOVMProject.getRfProject(), new FunctionVisitor(visitedFunctions, functionCallTree, childClass, "", 0));
        Set<RfClass> children = childClass.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (RfClass child : children) {
            this.recursiveChildVisiting(child, localFunction);
        }
    }

    protected String getFailMessage(RfHid hid, String callStack) {
        String message = "Function " + HidUtils.toNiceString((IHidObject)hid) + " called in a banned method!";
        if (!callStack.isEmpty()) {
            message = String.valueOf(message) + " Call stack: " + callStack;
        }
        return message;
    }

    private class FunctionVisitor
    extends RfHidVisitor {
        private List<RfFunction> functionCallTree;
        private Set<RfFunction> visitedFunctions = new HashSet<RfFunction>();
        private RfClass functionClass;
        private String callStackMessage;
        private Integer callIndex;

        public FunctionVisitor(Set<RfFunction> visitedFunctions, List<RfFunction> functionCallTree, RfClass functionClass, String callStackMessage, Integer callIndex) {
            this.visitedFunctions = visitedFunctions;
            this.functionCallTree = functionCallTree;
            this.functionClass = functionClass;
            this.callStackMessage = callStackMessage;
            this.callIndex = callIndex;
        }

        public boolean visit(RfHid hid) {
            RfFunction tempFunction;
            if (hid == null) {
                return true;
            }
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement hidNamedElement = hid.getElement();
            if (!(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)hidNamedElement;
            if (function.isVirtual() && (tempFunction = LintUtils.getValidVirtualFunction(function, hid, this.functionClass)) != null) {
                function = tempFunction;
            }
            RfFunction caller = this.functionCallTree.get(this.functionCallTree.size() - 1);
            String link = Check_SVTB_29_1_10.this.link(String.valueOf(Utils.getInstance().getFileName(this.parserPath.path)) + ":" + hid.getOccurrence().getLine(), this.parserPath.path, hid.getOccurrence().getLine());
            String message = "\n" + this.callIndex + ": " + Check_SVTB_29_1_10.this.link(caller) + "() - calls " + function + "() in " + link;
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
            if (methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                Hid methodHid = methodCall.getMethodHid();
                String methodFullName = LintUtils.getNamedElementFullName((RfNamedElement)methodHid.getElement());
                if (!Check_SVTB_29_1_10.this.pBannedMethods.contains(methodFullName)) continue;
                Check_SVTB_29_1_10.this.addHit(this.parserPath, hid, Check_SVTB_29_1_10.this.getFailMessage(hid, this.callStackMessage));
                this.visitedFunctions.remove(function);
            }
            if (this.visitedFunctions.contains(function)) {
                return true;
            }
            this.visitedFunctions.add(function);
            if (Check_SVTB_29_1_10.this.fOVMProject.isOVMElement(function)) {
                return true;
            }
            this.functionCallTree.add(function);
            function.visitHidObject(Check_SVTB_29_1_10.this.fOVMProject.getRfProject(), new FunctionVisitor(this.visitedFunctions, this.functionCallTree, this.functionClass, String.valueOf(this.callStackMessage) + message, this.callIndex + 1));
            this.functionCallTree.remove(this.functionCallTree.size() - 1);
            return true;
        }

        @Override
        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

