/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.29.1.2")
@CheckName(value="SVTB.29.1.2")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.PREDEFINED_METHOD})
@CheckTitle(value="Banned system math function calls")
@CheckDescription(value="Do not use $clog2 $asin $ln $acos $log10 $atan $exp $atan2 $sqrt $hypot $pow $sinh $floor $cosh $ceil $tanh $sin $asinh $cos $acosh $tan $atanh.\n\nExamples:\nclass my_class;\n\tfunction real compute(real x);\n\t\treturn $ln($tan(x / 4) + $sin(x)); // not allowed\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_29_1_2
extends AbstractSVTBSimpleIssues {
    public Check_SVTB_29_1_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(31);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return "Banned system math function call!";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        return this.fOVMProject.getSVTBIssuesWithKind(31);
    }
}

