/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.29.1.3.1")
@CheckName(value="SVTB.29.1.3.1")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.METHOD, RuleLabel.PREDEFINED_METHOD})
@CheckTitle(value="Banned random number system functions and methods calls")
@CheckDescription(value="Do not use\n $urandom, $urandom_range\n $random, $dist_uniform, $dist_normal, $dist_exponential, $dist_poisson, $dist_chi_square, $dist_t, $dist_erlang\n because members randomized with these calls cannot be constrained.\n\n srandom, get_randstate, set_randstate.\n use the simulator to set the random seed.\n\n Per methodology anything that is random can be constrained from a testcase. Limit randomization to classes, specifically transaction classes.\n\nExamples:\nmodule my_module;\n\tint x,y,z;\n\treal a;\n\tinitial begin\n\t\tx = $urandom(); // not allowed\n\t\ty = $random(); // not allowed\n\t\tz = $urandom_range(y, x); // not allowed\n\t\ta = $dist_t(x, y); // not allowed\n\t\ta = $dist_chi_square(x, y); // not allowed\n\tend\nendmodule\n\nCheck supports pre-waiving.")
public class Check_SVTB_29_1_3_1
extends OVMComplianceCheck {
    HashSet<String> functionNames = new HashSet();

    public Check_SVTB_29_1_3_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.functionNames.add("$urandom");
        this.functionNames.add("$urandom_range");
        this.functionNames.add("$random");
        this.functionNames.add("$dist_uniform");
        this.functionNames.add("$dist_normal");
        this.functionNames.add("$dist_exponential");
        this.functionNames.add("$dist_poisson");
        this.functionNames.add("$dist_chi_square");
        this.functionNames.add("$dist_t");
        this.functionNames.add("$dist_erlang");
        this.functionNames.add("srandom");
        this.functionNames.add("get_randstate");
        this.functionNames.add("set_randstate");
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new RandomCallVisitor(this));
    }

    private class RandomCallVisitor
    implements IHidVisitor<RfHid> {
        ParserPath parserPath;
        OVMComplianceCheck check;

        public RandomCallVisitor(OVMComplianceCheck check) {
            this.check = check;
        }

        public boolean visit(RfHid hidObject) {
            if (this.checkPreWaived()) {
                return true;
            }
            Check_SVTB_29_1_3_1.this.notifyCheckAlive();
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            if (Check_SVTB_29_1_3_1.this.functionNames.contains(function.getName()) && function.isPredefined()) {
                Check_SVTB_29_1_3_1.this.addHit(this.parserPath, hidObject, "Banned random system call '" + function.getName() + "'!");
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean checkPreWaived() {
            return Check_SVTB_29_1_3_1.this.fOVMProject.getProjectWaivers().pathIsPrewaived(this.parserPath, this.check);
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

