/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.29.1.3.2")
@CheckName(value="SVTB.29.1.3.2")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.RANDOMIZATION, RuleLabel.PREDEFINED_METHOD})
@CheckTitle(value="Banned std::randomize() calls")
@CheckDescription(value="Do not use std::randomize(var). Use classes for randomization.\n\nExamples:\nfunction int random(int value);\n\treturn std::randomize(value); // not allowed\nendfunction\n")
public class Check_SVTB_29_1_3_2
extends OVMComplianceCheck {
    public Check_SVTB_29_1_3_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement callContainer : this.fOVMProject.getAllNonXVMFunctionCallContainers()) {
            this.notifyCheckAlive();
            List<RfFunctionCall> allCalls = callContainer.getFunctionCallsWithPrefix("std::randomize", 1);
            if (allCalls == null || allCalls.isEmpty()) continue;
            for (RfFunctionCall call : allCalls) {
                this.addHit(call, "Banned std::randomize() call!");
            }
        }
    }
}

