/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractForbiddenMethodsCheck;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfListType;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.29.1.4.1")
@CheckName(value="SVTB.29.1.4.1")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.PREDEFINED_METHOD, RuleLabel.ARRAY})
@CheckTitle(value="Banned array methods min(), max(), unique(), unique_index() calls")
@CheckDescription(value="Do not use the array methods min(), max(), unique(), unique_index().\n\nExamples:\nmodule m1;\n\tint A[10:1];\n\tfunction void foo();\n\t\tint min_A[$] = A.min(); // not allowed\n\t\tint max_A[$] = A.max(); // not allowed\n\t\tint unique_A[$] = A.unique(); // not allowed\n\t\tint unique_index[$] = A.unique_index(); // not allowed\n\tendfunction\nendmodule\n")
public class Check_SVTB_29_1_4_1
extends AbstractForbiddenMethodsCheck {
    public Check_SVTB_29_1_4_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, "array");
    }

    @Override
    protected boolean isForbiddenMethod(String methodName) {
        return "max".equals(methodName) || "min".equals(methodName) || "unique".equals(methodName) || "unique_index".equals(methodName);
    }

    @Override
    protected boolean isOfCheckedType(IRfScope callerType) {
        return callerType instanceof RfListType;
    }
}

