/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractForbiddenMethodsCheck;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfListType;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.29.1.4.2")
@CheckName(value="SVTB.29.1.4.2")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.PREDEFINED_METHOD, RuleLabel.ARRAY})
@CheckTitle(value="Banned array reduction methods sum(), product(), and(), or(), xor()")
@CheckDescription(value="Do not use the array reduction methods.\nIf you need this functionality you can unroll the array in a loop.\n\nExamples:\nmodule m1;\n\tint A[10:1];\n\tint arr1 [2][];\n\tfunction void foo();\n\t\tint x = A.xor() + A.or() + A.and(); // not allowed\n\t\tarr1[1][0] = arr1[1].sum() + arr1[1].product(); // not allowed\n\tendfunction\nendmodule\n")
public class Check_SVTB_29_1_4_2
extends AbstractForbiddenMethodsCheck {
    public Check_SVTB_29_1_4_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, "array");
    }

    @Override
    protected boolean isForbiddenMethod(String methodName) {
        return "sum".equals(methodName) || "product".equals(methodName) || "and".equals(methodName) || "or".equals(methodName) || "xor".equals(methodName);
    }

    @Override
    protected boolean isOfCheckedType(IRfScope callerType) {
        return callerType instanceof RfListType;
    }
}

