/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractForbiddenMethodsCheck;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfListType;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.29.1.5.1")
@CheckName(value="SVTB.29.1.5.1")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.PREDEFINED_METHOD, RuleLabel.ARRAY})
@CheckTitle(value="Banned associative array num() calls")
@CheckDescription(value="Do not use the associative array num() method.\nThe num() method is inconsistent with all of the other array methods. Use size() instead.\n\nExamples:\nmodule m1;\n\tinteger arr1[*];\n\tfunction void foo();\n\t\tint length1 = arr1.num(); // not allowed\n\t\tint length2 = arr1.size(); // allowed\n\tendfunction\nendmodule\n")
public class Check_SVTB_29_1_5_1
extends AbstractForbiddenMethodsCheck {
    public Check_SVTB_29_1_5_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, "associative array");
    }

    @Override
    protected boolean isForbiddenMethod(String methodName) {
        return "num".equals(methodName);
    }

    @Override
    protected boolean isOfCheckedType(IRfScope callerType) {
        return callerType instanceof RfListType && ((RfListType)callerType).isAssociativeArray();
    }
}

