/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractForbiddenMethodsCheck;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.29.1.6.1")
@CheckName(value="SVTB.29.1.6.1")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.PREDEFINED_METHOD, RuleLabel.STRING})
@CheckTitle(value="Banned string search method calls")
@CheckDescription(value="The string search methods from OpenVera are not included in the System Verilog LRM.\nThe methods are: search(), match(), postmatch(), prematch(), thismatch(), backref().\n\nExamples:\nmodule m1;\n\tstring s1;\n\tfunction void foo();\n\t\ts1.search(\"abc\"); // not allowed\n\t\ts1.match(\"abc\"); // not allowed\n\t\ts1.postmatch(); // not allowed\n\t\ts1.prematch(); // not allowed\n\t\ts1.thismatch(); // not allowed\n\t\ts1.backref(\"abc\"); // not allowed\n\tendfunction\nendmodule\n")
public class Check_SVTB_29_1_6_1
extends AbstractForbiddenMethodsCheck {
    public Check_SVTB_29_1_6_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, "string");
    }

    @Override
    protected boolean isForbiddenMethod(String methodName) {
        return "search".equals(methodName) || "match".equals(methodName) || "prematch".equals(methodName) || "postmatch".equals(methodName) || "thismatch".equals(methodName) || "backref".equals(methodName);
    }

    @Override
    protected boolean isOfCheckedType(IRfScope callerType) {
        return callerType instanceof RfPredefinedScalarType && "string".equals(callerType.getName());
    }
}

