/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.Check_SVTB_29_1_0;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="3.2")
@CheckID(value="SVTB.29.1.7")
@CheckName(value="SVTB.29.1.7")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.PREDEFINED_METHOD, RuleLabel.MESSAGING})
@CheckTitle(value="Banned $display and $write I/O system tasks")
@CheckDescription(value="Do not use:\n $display, $displayb, $displayo, $displayh\n $write, $writeb, $writeo, $writeh\n Display/reporting is done by the methodology.\n\nExamples:\nclass c1;\n\tfunction void foo();\n\t\t$display(\"abc\"); // not allowed\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="bannedMethods", defaultValue="$display, $displayb, $displayo, $displayh, $write, writeb, writeo, writeh", isVisible=false), @CheckParameterOverride(name="bannedMethodsPatterns", isVisible=false), @CheckParameterOverride(name="bannedScopes", isVisible=false)})
public class Check_SVTB_29_1_7
extends Check_SVTB_29_1_0 {
    @CheckParameter(defaultValue="false", description="When true, banned method calls from static methods are skipped.", name="skipCallsInStaticMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipCallsInStaticMethods;
    @CheckParameter(defaultValue="false", description="When true, banned method calls within initial and final blocks are skipped.", name="skipCallsInInitialAndFinalBlocks", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipCallsInInitialAndFinalBlocks;

    public Check_SVTB_29_1_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.skipScopeChecking = this.pSkipBaseClassPatterns.isEmpty() && this.pSkipClassPatterns.isEmpty() && !this.pSkipCallsInStaticMethods && !this.pSkipCallsInInitialAndFinalBlocks;
        this.performCheckBase();
    }

    @Override
    public boolean skipScope(IRfScopeElement scope) {
        RfFunction functionScope;
        if (scope == null) {
            return false;
        }
        if (this.pSkipCallsInStaticMethods && (functionScope = (RfFunction)scope.getEnclosingScope(RfFunction.class)) != null && functionScope.isObjectStatic()) {
            return true;
        }
        if (this.pSkipCallsInInitialAndFinalBlocks) {
            if (scope instanceof RfDefElement) {
                scope = ((RfDefElement)scope).getNamedElement();
            }
            while (scope instanceof RfActionBlock) {
                RfActionBlock blockScope = (RfActionBlock)scope;
                if (blockScope.isInitial() || blockScope.isFinal()) {
                    return true;
                }
                scope = scope.getEnclosingScope();
            }
        }
        return false;
    }
}

