/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.29.2")
@CheckName(value="SVTB.29.2")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.METHOD, RuleLabel.ARGUMENT})
@CheckTitle(value="Banned const ref method arguments")
@CheckDescription(value="Passing by constant reference is not allowed.\n\nNote: Arguments of UVM overidden methods are not checked.\n\nExamples:\nclass A;\n\tfunction foo(const ref int a); // not allowed\n\tendfunction\n\n\tfunction bar(int a); // allowed\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_29_2
extends OVMComplianceCheck {
    public Check_SVTB_29_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        IRfNamedElementVisitor visitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (!(namedElement instanceof RfField)) {
                    return true;
                }
                Check_SVTB_29_2.this.notifyCheckAlive();
                if (Check_SVTB_29_2.this.checkPreWaivers(namedElement.getFile())) {
                    return true;
                }
                RfField rfField = (RfField)namedElement;
                if (!rfField.isArgument() || !rfField.isConstRef()) {
                    return true;
                }
                RfFunction enclosingFunction = rfField.getEnclosingScope(RfFunction.class);
                if (Check_SVTB_29_2.this.fOVMProject.isOVMFunctionOverride(enclosingFunction)) {
                    return true;
                }
                Check_SVTB_29_2.this.addHit(rfField, "Banned argument passed by constant reference!");
                return true;
            }
        };
        this.fOVMProject.getRfProject().accept(visitor);
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

