/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractClassUseCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;

@CheckVersion(value="3.2")
@CheckID(value="SVTB.29.3.0")
@CheckName(value="SVTB.29.3.0")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.CLASS})
@CheckTitle(value="Banned classes")
@CheckDescription(value="Do not use 'bannedClasses'.\n\nImplementation Notes:\nFor each class not in 'skipClassesWithPrefixes' check that:\n - It does not extend from a 'bannedClasses'.\n - It does not have a type parameter of a 'bannedClasses' type.\n - It does not contain fields of a 'bannedClasses' type.\n - It does not contain methods with result or arguments of a 'bannedClasses' type.\n The key type of associative arrays is also checked.\n\nExamples for bannedClasses = 'A':\nclass A;\n\tfunction foo(int a);\n\tendfunction\nendclass\n\nclass A_helper extends A; // not allowed\n\tfunction bar(int a);\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_29_3_0
extends AbstractClassUseCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of banned classes full names.", name="bannedClasses", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pBannedClassesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of class prefixes to skip checking, for example uvm_pkg::uvm_.", name="skipClassesWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pSkipClassesWithPrefixesValue;
    @CheckParameter(defaultValue="false", description="When true signal only classes that extend from a ''bannedClasses''.", name="inheritanceOnly", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pInheritanceOnlyValue;

    public Check_SVTB_29_3_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.pBannedClassesValue == null || this.pBannedClassesValue.isEmpty()) {
            this.signalParamError("Parameter 'bannedClasses' not specified!", false);
            return;
        }
        this.performCheckBase();
    }

    @Override
    protected boolean skipClass(RfClass aClass) {
        return LintUtils.startsWithPrefixes(aClass.getFullName(), this.pSkipClassesWithPrefixesValue);
    }

    @Override
    protected boolean isClassOKToUse(RfClass aEnclosingClass, RfClass aClass) {
        if (aEnclosingClass != null && aEnclosingClass == aClass) {
            return true;
        }
        if (aClass == null) {
            return false;
        }
        return !this.pBannedClassesValue.contains(aClass.getFullName());
    }

    @Override
    protected String getSpecificMessage() {
        return "banned class type";
    }

    @Override
    protected boolean isOnlyInheritance() {
        return this.pInheritanceOnlyValue;
    }
}

