/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IReparseElement;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

@CheckVersion(value="3.2")
@CheckID(value="SVTB.29.4.0")
@CheckName(value="SVTB.29.4.0")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.MACRO})
@CheckTitle(value="Banned macros")
@CheckDescription(value="Do not use 'bannedMacros' or macros that match any of the patterns specified by 'bannedMacrosNamePatterns'.\n\nExamples for bannedMacros = 'macro1':\n`define macro1 125\n`define macro2 175\n\nclass A;\n\tfunction int foo();\n\t\tint x = `macro1; // not allowed\n\t\tint y = `macro2; // allowed\n\t\treturn x + y;\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_29_4_0
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of banned macros, for example bannedMacro1, bannedMacro2.", name="bannedMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pBannedMacrosValue;
    @CheckParameter(defaultValue="", description="Comma separated list of class prefixes to skip, for example uvm_pkg::uvm_.", name="skipClassesWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pSkipClassesWithPrefixesValue;
    @CheckParameter(defaultValue="", description="Comma separated list of regex that match the names of macros that should not be used.", name="bannedMacrosNamePatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pBannedMacrosNamePatterns;
    @CheckParameter(defaultValue="false", description="When true, the macro definitions will also be checked.", name="checkMacroDefinition", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckMacroDefinition;

    public Check_SVTB_29_4_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new MacroVisitor());
        MacroDefVisitor visitor = new MacroDefVisitor();
        RfProject rfProject = this.fOVMProject.getRfProject();
        try {
            rfProject.accept(visitor);
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (!this.pCheckMacroDefinition) {
            return;
        }
        for (VlogMacroInfo macro : this.fOVMProject.getAllMacros()) {
            VlogFileInstance fileInstance = macro.getFileInstance();
            if (fileInstance == null || this.checkPrewaivers(fileInstance.getParserPath())) continue;
            this.notifyCheckAlive();
            RfClass enclosingClass = macro.getEnclosingScope(RfClass.class);
            if (enclosingClass != null && this.skipClass(enclosingClass)) continue;
            this.checkBannedMacro(fileInstance.getParserPath(), macro.getName(), macro.getLine());
        }
    }

    private boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    protected boolean skipClass(RfClass aClass) {
        return LintUtils.startsWithPrefixes(aClass.getFullName(), this.pSkipClassesWithPrefixesValue);
    }

    public ReparseInfo.ReparseElement wrappedMacro(IReparseInfo reparserInfo) {
        if (reparserInfo instanceof ReparseInfo) {
            ReparseInfo.ReparseElement[] reparseStack = ((ReparseInfo)reparserInfo).getReparseStack();
            if (reparseStack.length == 0) {
                return ((ReparseInfo)reparserInfo).getLastReparseElement();
            }
            return reparseStack[0];
        }
        return null;
    }

    public boolean skipClass(RfNamedElement element) {
        if (element == null) {
            return false;
        }
        RfClass enclosingScope = element.getEnclosingScope(RfClass.class);
        if (enclosingScope != null) {
            return this.skipClass(enclosingScope);
        }
        return false;
    }

    public void checkBannedMacro(ParserPath parserPath, String macroName, int occurenceLine) {
        this.notifyCheckAlive();
        if (this.pBannedMacrosValue.contains(macroName)) {
            this.addHit(parserPath, occurenceLine, "Banned macro '" + macroName + "'!", null);
            return;
        }
        this.matchesPattern(parserPath, occurenceLine, macroName);
    }

    private void matchesPattern(ParserPath parserPath, int occurenceLine, String macroCall) {
        for (Pattern pattern : this.pBannedMacrosNamePatterns) {
            if (!pattern.matcher(macroCall).matches()) continue;
            this.addHit(parserPath, occurenceLine, "Macro name '" + macroCall + "' matches the banned pattern:'" + pattern.pattern() + "'!", null);
            return;
        }
    }

    private class MacroDefVisitor
    implements IRfDefElementVisitor {
        private MacroDefVisitor() {
        }

        @Override
        public boolean visit(RfDefElement defElement) throws Exception {
            return false;
        }

        @Override
        public void preVisit(RfDefElement defElement) throws Exception {
            Check_SVTB_29_4_0.this.notifyCheckAlive();
            if (Check_SVTB_29_4_0.this.checkPrewaivers(defElement.getParserPath())) {
                return;
            }
            ReparseInfo reparseInfo = defElement.getReparseInfo();
            if (reparseInfo == null) {
                return;
            }
            RfNamedElement scope = defElement.getNamedElement();
            if (scope == null) {
                return;
            }
            ReparseInfo.ReparseElement reparseElement = Check_SVTB_29_4_0.this.wrappedMacro(reparseInfo);
            if (reparseElement == null) {
                return;
            }
            if (!Check_SVTB_29_4_0.this.skipClass(scope)) {
                Check_SVTB_29_4_0.this.checkBannedMacro(defElement.getParserPath(), reparseElement.getReparseMacroName(), defElement.getStartLine());
            }
        }

        @Override
        public void postVisit(RfDefElement defElement) throws Exception {
        }
    }

    private class MacroVisitor
    implements IHidVisitor<IHidObject> {
        private RfNamedElement scope;
        private ParserPath path;

        private MacroVisitor() {
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public void setParserPath(ParserPath parserPath) {
            this.path = parserPath;
        }

        public boolean visit(IHidObject hidObject) {
            if (Check_SVTB_29_4_0.this.checkPrewaivers(this.path)) {
                return true;
            }
            if (hidObject instanceof Hid) {
                IReparseInfo reparserInfo = ((Hid)hidObject).getReparseInfo();
                HidOccurrence occurence = ((Hid)hidObject).getOccurrence();
                if (reparserInfo == null) {
                    return true;
                }
                ReparseInfo.ReparseElement reparseElement = Check_SVTB_29_4_0.this.wrappedMacro(reparserInfo);
                if (reparseElement == null) {
                    return true;
                }
                if (!Check_SVTB_29_4_0.this.skipClass(this.scope) && occurence != null) {
                    Check_SVTB_29_4_0.this.checkBannedMacro(this.path, reparseElement.getReparseMacroName(), occurence.getLine());
                }
                return true;
            }
            if (hidObject instanceof HidOperator) {
                IReparseInfo reparserInfo = ((HidOperator)hidObject).getReparseInfo();
                HidOperatorOccurrence occurence = ((HidOperator)hidObject).getOccurrence();
                if (reparserInfo == null) {
                    return true;
                }
                ReparseInfo.ReparseElement reparseElement = Check_SVTB_29_4_0.this.wrappedMacro(reparserInfo);
                if (reparseElement == null) {
                    return true;
                }
                if (!Check_SVTB_29_4_0.this.skipClass(this.scope) && occurence != null) {
                    Check_SVTB_29_4_0.this.checkBannedMacro(this.path, reparseElement.getReparseMacroName(), occurence.getLine());
                }
                return true;
            }
            if (hidObject instanceof HidImplicit) {
                IReparseElement reparseElement = ((HidImplicit)hidObject).getLastReparseElement();
                if (reparseElement == null) {
                    return true;
                }
                Check_SVTB_29_4_0.this.checkBannedMacro(this.path, reparseElement.getReparseMacroName(), reparseElement.getReparseMacroLine());
            }
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

